<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
include_once dirname(__FILE__) . '/models/Alert.php';
include_once dirname(__FILE__) . '/models/SearchFilter.php';
include_once dirname(__FILE__) . '/models/Paging.php';

class CTMobile_WS_GetAllUserLocation extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		global $adb, $current_user;
		$current_user = $this->getActiveUser();
		$userId = trim($request->get('userid'));
		$userId = substr($userId, stripos($userId, 'x')+1);
		$usersRecordModel = Users_Record_Model::getInstanceById($userId,'Users');
		$users = $usersRecordModel->getAccessibleUsers();
		$AccesibleUsers = array_keys($users);
		
		$userData = array();
		$userQuery = $adb->pquery("SELECT DISTINCT(userid) FROM ctmobile_userderoute INNER JOIN vtiger_users ON vtiger_users.id = ctmobile_userderoute.userid  WHERE ctmobile_userderoute.userid != '".$userId."'");
		$userNumRows = $adb->num_rows($userQuery);
		$datefind=date("Y-m-d H:i:s",strtotime("-30 minutes"));
		for($k=0;$k<$userNumRows;$k++){
			$user_id = $adb->query_result($userQuery,$k,'userid');
			if(!$this->checklivetrackingPermission($user_id)){
				continue;
			}
			if(!in_array($user_id,$AccesibleUsers)){
				continue;
			}
	    $selectUserQuery = $adb->pquery("SELECT * FROM ctmobile_userderoute INNER JOIN vtiger_users ON vtiger_users.id = ctmobile_userderoute.userid WHERE vtiger_users.deleted =0
                                    AND ctmobile_userderoute.userid =? AND ctmobile_userderoute.createdtime > ? ORDER BY ctmobile_userderoute.id DESC LIMIT 1", array($user_id,$datefind));									
		$selectUserQueryCount = $adb->num_rows($selectUserQuery);
		
			for($i=0;$i<$selectUserQueryCount;$i++) {
				$userid = $adb->query_result($selectUserQuery, $i, 'id');
				$userRecordModel = Vtiger_Record_Model::getInstanceById($userid, 'Users');
				$first_name = trim($userRecordModel->get('first_name'));
				$last_name = trim($userRecordModel->get('last_name'));
				$userName = html_entity_decode($first_name." ".$last_name, ENT_QUOTES, $default_charset);
				$latitude = trim($adb->query_result($selectUserQuery, $i, 'latitude'));
				$longitude = trim($adb->query_result($selectUserQuery, $i, 'longitude'));
				$userImage = CTMobile_WS_Utils::getUserImage($userid);
				$userData[] =  array('userid'=>$userid, 'latitude'=>$latitude, 'longitude'=>$longitude, 'username'=>$userName,'userImage'=>$userImage);
			} 
		}
		$response = new CTMobile_API_Response();
		if(count($userData) == 0) {
			$message = $this->CTTranslate('No records found');
			$response->setResult(array('records'=>array(),'message'=>$message));
		}else{
			$response->setResult(array('records'=>$userData,'message'=>""));
		}
		return $response;				
	}

	function checklivetrackingPermission($user_id){
		global $adb;
		$checkPermLive = $adb->pquery("SELECT user_setting_type,user_setting_value FROM ctmobile_user_settings WHERE user_setting_type = ? AND user_setting_value = ?",array('location_tracking','1'));
		if($adb->num_rows($checkPermLive) > 0){
			$liveuserQuery = $adb->pquery("SELECT 1 FROM ctmobile_livetracking_users WHERE userid = ?",array($user_id));
			if($adb->num_rows($liveuserQuery) > 0){
				$livetracking = true;
			}else{
				$livetracking = false;
			}
		}else{
			$livetracking = false;
		}
		return $livetracking;
	}
}

?>
