/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

Inventory_List_Js("Quotes_List_Js",{
    addToGrupaje: function () {
        // Verificar si hay registros seleccionados
        if (this.getSelectedRecords() != null) {
            var listInstance = app.controller();
            var selectedRecords = this.getSelectedRecords();
            
            // Definir los parámetros para el popup
            var params = {
                'module': 'Grupaje', // Módulo que quieres mostrar en el popup (puedes cambiarlo)
                'src_module': 'Quotes',
                'src_record': '', // Dejamos vacío porque son múltiples registros
                'multi_select': false, // Solo permitir selección única
                'view': 'Popup'
            };
            
            // Desactivar eventos previos para evitar duplicados
            app.event.off('Quotes_List_Js.PopupSelectionEvent');
            
            // Registrar el evento para manejar la selección del popup
            app.event.one('Quotes_List_Js.PopupSelectionEvent', function(e, data) {
                if (!data) return;
                
                // Procesar los datos seleccionados
                var responseData = JSON.parse(data);
                var recordId = Object.keys(responseData)[0];
                var selectedData = responseData[recordId];
                
                // Ejecutar la llamada AJAX con los datos seleccionados y los quotes marcados
                var aDeferred = jQuery.Deferred();
        
                // Combinar los parámetros de los quotes seleccionados con la información del registro relacionado
                var params = jQuery.extend({}, selectedRecords, {
                    'module': 'Quotes',
                    'action': 'addQuoteToGrupaje', // Tu acción personalizada
                    'related_record_id': selectedData,
                    'related_module': 'Grupaje' // El módulo del registro seleccionado en el popup
                });
                
                // Mostrar mensaje de procesamiento
                var progressIndicatorElement = jQuery.progressIndicator({
                    'message': 'Procesando...',
                    'position': 'html',
                    'blockInfo': {
                        'enabled': true
                    }
                });
                
                // Realizar la llamada AJAX
                AppConnector.request(params).then(
                    function(data) {
                        progressIndicatorElement.progressIndicator({'mode': 'hide'});
                        
                        if (data.success) {
                            // Manejo de respuesta exitosa

                            Vtiger_Helper_Js.showMessage({
                                title: data.result.message || 'Registros procesados exitosamente',
                                type: 'success',
                                delay: 8000
                            });
                            
                            // Recargar la lista para mostrar los cambios
                            var listInstance = app.controller();
                            listInstance.loadListViewRecords();
                            
                            aDeferred.resolve(data);
                        } else {
                            // Manejo de error
                            Vtiger_Helper_Js.showMessage({
                                title: data.error.message || 'Error al procesar los registros',
                                type: 'error'
                            });
                            aDeferred.reject(data.error);
                        }
                    },
                    function(error) {
                        progressIndicatorElement.progressIndicator({'mode': 'hide'});
                        aDeferred.reject(error);
                    }
                );
            });
            
            // Crear instancia del popup y mostrarlo
            var popupInstance = Vtiger_Popup_Js.getInstance();
            popupInstance.showPopup(params, 'Quotes_List_Js.PopupSelectionEvent', function() {
                // Callback después de que se muestra el popup (opcional)
            });
        }
    },
    createGrupaje: function () {
        if(this.getSelectedRecords() != null)
        {
            var instance = new Vtiger_Index_Js();
            var quickCreateUrl = "index.php?module=Grupaje&view=QuickCreateAjax";
            var quickCreateModuleName = "Grupaje";
    
            if (typeof params === 'undefined') {
                params = {};
            }
            if (typeof params.callbackFunction === 'undefined') {
                params.callbackFunction = function(data, err) {
                    //fix for Refresh list view after Quick create
                    var listinstance = app.controller();
                    listinstance.loadListViewRecords();
                };
            }
    
            app.helper.showProgress();
            instance.getQuickCreateForm(quickCreateUrl,quickCreateModuleName,params).then(function(data){
                app.helper.hideProgress();
                var callbackparams = {
                    'cb' : function (container){
                        instance.registerPostReferenceEvent(container);
                        app.event.trigger('post.QuickCreateForm.show',form);
                        app.helper.registerLeavePageWithoutSubmit(form);
                        app.helper.registerModalDismissWithoutSubmit(form);
                    },
                    backdrop : 'static',
                    keyboard : false
                }
    
                app.helper.showModal(data, callbackparams);
                var form = jQuery('form[name="QuickCreate"]');
                var moduleName = form.find('[name="module"]').val();
                var Options= {
                    scrollInertia: 200,
                    autoHideScrollbar: true,
                    setHeight:(jQuery(window).height() - jQuery('form[name="QuickCreate"] .modal-body').find('.modal-header').height() - jQuery('form[name="QuickCreate"] .modal-body').find('.modal-footer').height()- 135),
                }
                app.helper.showVerticalScroll(jQuery('form[name="QuickCreate"] .modal-body'), Options);
    
                var targetInstance = instance;
                var moduleInstance = Vtiger_Edit_Js.getInstanceByModuleName(moduleName);
                if(typeof(moduleInstance.quickCreateSave) === 'function'){
                    targetInstance = moduleInstance;
                    targetInstance.registerBasicEvents(form);
                }
    
                vtUtils.applyFieldElementsView(form);
                targetInstance.quickCreateSave(form,params);
            });
        }
        
    
	},
    getSelectedRecords: function () {
        var listInstance = app.controller();
		var listSelectParams = listInstance.getListSelectAllParams(true)
        if (!listSelectParams) {
			listInstance.noRecordSelectedAlert();
		}
        else{
            return listSelectParams;
        }
    },
},{
    registerEvents: function () {
		var thisInstance = this;
		this._super();
        this.initListQuotes();
    },
    initListQuotes: function () {
		$(document).ready(function() {
            //$('#Quotes_listView_advancedAction_Crear_Grupaje').css('background','#a2f172');
            //$('#Quotes_listView_advancedAction_Agregar_a_Grupaje_Existente').css('background','#5bc0de');
        });
    },
});