/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
Settings_Vtiger_List_Js("CTMobileSettings_AddressPopup_Js", {
}, {

	registerClickEvent : function(){
		jQuery(document).on('click','.CTNonAddressEntries',function(){
            var id = jQuery(this).attr('data-id');
            var module =  jQuery('#search_module').val();
            var url = 'index.php?module='+module+'&view=Detail&record='+id;
            window.open(url,'_blank');
        });
	},

	getDefaultParams: function () {
		var container = this.getListViewContainer();
		var pageNumber = container.find('#pageNumber').val();
		var module = this.getModuleName();
		var parent = app.getParentModuleName();
		var cvId = this.getCurrentCvId();
		var orderBy = container.find('[name="orderBy"]').val();
		var sortOrder = container.find('[name="sortOrder"]').val();
		var appName = container.find('#appName').val();
		var search_module = container.find('#search_module').val();
		var params = {
			'module': module,
			'parent': parent,
			'page': pageNumber,
			'view': "AddressPopup",
			'cvid': cvId,
			'orderby': orderBy,
			'sortorder': sortOrder,
			'app': appName,
			'src_module':search_module
		}
		params.search_params = JSON.stringify(this.getListSearchParams());
		params.tag_params = JSON.stringify(this.getListTagParams());
		params.nolistcache = (container.find('#noFilterCache').val() == 1) ? 1 : 0;
		params.starFilterMode = container.find('.starFilter li.active a').data('type');
		params.list_headers = container.find('[name="list_headers"]').val();
		params.tag = container.find('[name="tag"]').val();
		return params;
	},

	initializePaginationEvents: function () {
		var thisInstance = this;
		var paginationObj = new Vtiger_Pagination_Js();
		var listViewContainer = thisInstance.getListViewContainer();
		paginationObj.initialize(listViewContainer);

		app.event.on(paginationObj.nextPageButtonClickEventName, function () {
			var pageLimit = listViewContainer.find('#pageLimit').val();
			var noOfEntries = listViewContainer.find('#noOfEntries').val();
			var nextPageExist = listViewContainer.find('#nextPageExist').val();
			var pageNumber = listViewContainer.find('#pageNumber').val();
			var nextPageNumber = parseInt(parseFloat(pageNumber)) + 1;
			if (noOfEntries === pageLimit && nextPageExist) {
				var urlParams = {};
				listViewContainer.find("#pageNumber").val(nextPageNumber);
				thisInstance.loadListViewRecords(urlParams);
			}
		});

		app.event.on(paginationObj.previousPageButtonClickEventName, function () {
			var pageNumber = listViewContainer.find('#pageNumber').val();
			var previousPageNumber = parseInt(parseFloat(pageNumber)) - 1;

			if (pageNumber > 1) {
				var urlParams = {};
				listViewContainer.find('#pageNumber').val(previousPageNumber);
				thisInstance.loadListViewRecords(urlParams);
			}
		});

		app.event.on(paginationObj.pageJumpButtonClickEventName, function (event, currentEle) {
			thisInstance.pageJump();
		});

		app.event.on(paginationObj.totalNumOfRecordsButtonClickEventName, function (event, currentEle) {
			thisInstance.totalNumOfRecords(currentEle);
		});

		app.event.on(paginationObj.pageJumpSubmitButtonClickEvent, function (event, currentEle) {
			thisInstance.pageJumpOnSubmit(currentEle);
		});
	},

	registerEvents : function(){
		this.registerClickEvent();
		//this.initializePaginationEvents();
	}
});

jQuery(document).ready(function () {
	
	var instance = new CTMobileSettings_AddressPopup_Js();
	instance.registerEvents();
    instance.initializePaginationEvents();
	
    
    var searchListInstance = new Vtiger_SearchList_Js();
    var BasicSearchInstance = new Vtiger_BasicSearch_Js();
    BasicSearchInstance.registerEvents();
    var vtigerInstance = new Settings_Vtiger_Index_Js();
    vtigerInstance.registerEvents();
});