<?php
chdir('../../');
set_time_limit(1000);

require_once 'libraries/PHPExcel/PHPExcel.php';
require_once 'libraries/PHPExcel/PHPExcel/IOFactory.php';
require_once 'includes/Loader.php';
require_once ("integraciones/Main/SC_model.php");


try {
    // Verificar si se subió un archivo
    if (!isset($_FILES['excelFile']) || $_FILES['excelFile']['error'] !== UPLOAD_ERR_OK) {
        throw new Exception('No se recibió el archivo correctamente');
    }
    
    $inputFileName = $_FILES['excelFile']['tmp_name'];
    $fileType = PHPExcel_IOFactory::identify($inputFileName);
    $objReader = PHPExcel_IOFactory::createReader($fileType);
    $objReader->setReadDataOnly(true);
    $objPHPExcel = $objReader->load($inputFileName);
    // Obtener la hoja activa
    $worksheet = $objPHPExcel->getActiveSheet() ?? $objPHPExcel->getSheet(0);;
    //$worksheet = $objPHPExcel->getSheetByName("Nombre de la Hoja");
    //echo '<pre>'; print_r($worksheet); die;
    $highestRow = $worksheet->getHighestRow();
    $highestColumn = $worksheet->getHighestColumn();
    $highestColumnIndex = PHPExcel_Cell::columnIndexFromString($highestColumn);

    // Obtener los encabezados
    $headers = [];
    for ($col = 0; $col < $highestColumnIndex; $col++) {
        $headers[] = trim($worksheet->getCellByColumnAndRow($col, 1)->getValue());
    }

    // Leer los datos
    $data = [];
    for ($row = 2; $row <= $highestRow; $row++) {
        $rowData = [];
        for ($col = 0; $col < $highestColumnIndex; $col++) {
            $value = trim($worksheet->getCellByColumnAndRow($col, $row)->getValue());
            
            //Indices para ubicarlo mas rapido en javascript
            $name_index = setNameIndex($col);
            
            // Si es la primera columna (col = 0), procesar con la función especial
            if ($col === 0) {
                $productInfo = getProductByName($value);
                $rowData[$name_index] = $value;
                // Agregar el valor adicional de la consulta
                $rowData["producto_id"] = $productInfo ? $productInfo['productid'] : '';
            } else {
                $rowData[$name_index] = $value;
            }
        }

        //Solo agregos la fila con datos
        if (array_filter($rowData)) {
            $data[] = $rowData;
        }
        //$data[] = $rowData;
    }

    // Devolver respuesta exitosa
    echo json_encode([
        'success' => true,
        'message' => 'Archivo procesado correctamente',
        'data' => $data,
        'headers' => $headers,
        'post' => (object) $_POST
    ]);

} catch (Exception $e) {
    // Devolver error
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}


function getProductByName($productName)
{
    global $adb, $current_user;
    
    // Preparar y ejecutar la consulta
    $sql = "SELECT *FROM vtiger_products p 
        INNER JOIN vtiger_crmentity e ON e.crmid = p.productid
        WHERE p.productname = '{$productName}' AND e.deleted = 0 LIMIT 1 ";
    $res = $adb->query($sql);
    $result = $adb->fetch_array($res);
    
    return $result ? $result : null;
}

function setNameIndex($value){
    $name_index = "no_index";
    switch($value){
        case 0: $name_index = "producto_nombre"; break;
        case 1: $name_index = "codigo"; break;
        case 2: $name_index = "codigo_nuevo"; break;
        case 3: $name_index = "descripcion_aleman"; break;
        case 4: $name_index = "descripcion_espanol"; break;
        case 5: $name_index = "cantidad"; break;
        case 6: $name_index = "precio"; break;
        case 7: $name_index = "descuento_porcentaje"; break;
        case 8: $name_index = "descuento_directo"; break;
        default: $name_index = "no_index"; break;
    }
    return $name_index;
}

?>