<?php
require_once 'include/utils/VtlibUtils.php';
require_once("include/utils/utils.php");

Class SC_Integration {
    public $Token = '';


    public function __construct()
    {

    }
    
    /**
     * Realiza una solicitud HTTP utilizando cURL.
     *
     * Esta función permite realizar solicitudes HTTP utilizando la librería cURL de PHP.
     * Puede ser utilizada para enviar datos POST, GET y configurar encabezados personalizados.
     *
     * @param string $method       El método HTTP a utilizar (por ejemplo, "GET" o "POST").
     * @param array  $params       Los parámetros de la solicitud, incluyendo opciones como "file", "postBody", "headers", etc.
     *
     * @return array|null          Un arreglo que contiene el encabezado de la respuesta, el cuerpo de la respuesta (decodificado como JSON)
     *                            y el código de estado HTTP, o NULL si se produce un error.
     */
    static function sendHTPP_request($params = null,$method = 'GET')
    {
        global $current_user, $domain_lds;

        #Activar para debuggear request
        $debug_curl = false;

        if(!empty($params['file']) && file_exists($params['file']))
        {
            $cf = new CURLFile($params['file'],'application/octet-stream','file.txt');
            $postBody["parametros"] = json_encode($params["postBody"]);
            $postBody["archivo"] = $cf;
            $headers = [
                "Content-Type: multipart/form-data",
            ];
        }
        else{
            $postBody = (!empty($params["postBody"])) ? json_encode($params["postBody"]) : NULL;
            $headers = [
                "Accept: application/json",
                "Content-Type: application/json",
            ];
        }

        if(!empty($_SESSION['scToken']['token']))
        {
            $headers[] = "AuthLDS: ".$_SESSION['scToken']['token'];
        }

        $segment = (isset($params["segment"])) ? "/".$params["segment"] : NULL;
        $getParam = isset($params["getParam"]) ? "?".http_build_query($params["getParam"]) : NULL;
        
        if($debug_curl)
        {
            ob_start();  
            $out = fopen('php://output', 'w');
        }
        
        $curl = curl_init();
        
        
        if(!empty($params["headers"]))
        {
            foreach ($params["headers"] as $key => $value) {
                $headers[] = "$key: $value";
            }
        }

        curl_setopt_array($curl, [
            CURLOPT_URL => $domain_lds.$segment.$getParam,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => strtoupper($method),
            CURLOPT_POSTFIELDS => $postBody,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_SSL_VERIFYHOST => FALSE,
            CURLOPT_SSL_VERIFYPEER => FALSE,
            CURLOPT_HEADER => 1,
        ]);
        if($debug_curl)
        {
            curl_setopt($curl, CURLOPT_VERBOSE, TRUE);  
            curl_setopt($curl, CURLOPT_STDERR, $out);  
            }
        $response = curl_exec($curl);

        $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE); 
        list($header, $body) = explode("\r\n\r\n", $response, 2);

        $err = curl_error($curl);
        curl_close($curl);
        if($debug_curl)
        {
            fclose($out);  
            $debug = ob_get_clean();
            debug($debug,true);
        }

        if ($err) {
            $result['code'] = 500;
            $result['error'] = "cURL Error #:" . $err;
        } else {
            $result['header'] 	= $header;
            $result['body'] 	= json_decode($body,true);
            $result['http_status'] = curl_getinfo($curl, CURLINFO_RESPONSE_CODE);
            $result['url'] = $domain_lds;
            $result['params'] = $params;
            $result['code'] = 200;
        }
        return $result;
        
    }

    /**
     * Determina si un valor está en el formato '/Date(...)/'.
     *
     * @param string $value El valor a verificar.
     * @return bool True si el valor está en el formato '/Date(...)/', false en caso contrario.
     */
    public static function esFormatoFecha($value) {
        return (strpos($value, '/Date(') === 0 && strpos($value, ')/') !== false);
    }

    /**
     * Convierte una cadena de tiempo en formato '/Date(...)/' a una cadena de fecha y hora en el formato 'Y-m-d H:i:s'.
     *
     * @param string $timeString La cadena de tiempo en formato '/Date(...)/'.
     * @return string|null La cadena de fecha y hora en formato 'Y-m-d H:i:s' o null si hay un error.
     */
    public static function convertirFecha($timeString) {
        // Extraer la parte numérica de la cadena de tiempo
        preg_match('/\((\d+)-(\d+)\)/', $timeString, $matches);
    
        if (count($matches) >= 3) {
            $timestamp = $matches[1] / 1000; // Convertir milisegundos a segundos
            $timezoneOffset = $matches[2];
    
            // Crear un objeto DateTime ajustando la zona horaria
            $datetime = new DateTime("@$timestamp");
            $timezoneHours = substr($timezoneOffset, 0, 3);
            $timezoneMinutes = substr($timezoneOffset, 3);
            $timezone = ($timezoneHours >= 0 ? '+' : '-') . $timezoneHours . ' hours ' . $timezoneMinutes . ' minutes';
            $datetime->modify($timezone);
    
            return $datetime->format('Y-m-d H:i:s');
        } else {
            // No se pudo extraer la parte numérica y la zona horaria
            return null;
        }
    }

    /**
     * Cambia los nombres de las claves en un arreglo según un mapeo dado.
     *
     * @param array $arreglo El arreglo original.
     * @param array $mapeoNombres El mapeo de nombres de claves (clave original => nueva clave).
     * @return array El arreglo modificado con los nombres de claves cambiados.
     */
    public static function renombrarClaves($arreglo, $mapeoNombres) {
        $arregloModificado = array();
        foreach ($arreglo as $clave => $valor) {
            // Verificar si hay una clave en el mapeo y usarla si existe, de lo contrario, mantener la clave original
            if($mapeoNombres[$clave] && !is_array($mapeoNombres[$clave])){
            $nuevaClave = isset($mapeoNombres[$clave]) ? $mapeoNombres[$clave] : $clave;
            $arregloModificado[$nuevaClave] = $valor;
            }else{
            $arregloModificado[$clave] = $valor;

            }

        }
        //echo '<pre>'; print_r($arregloModificado); die();

        return $arregloModificado;
    }


    /**
     * Recorre un array y convierte los valores de fecha y hora en el formato '/Date(...)/' a 'Y-m-d H:i:s'.
     *
     * @param array $array El array de datos.
     * @param array|null $mapeoNombres El mapeo de nombres de claves (clave original => nueva clave) o null si no se proporciona.
     * @return array El array modificado con las fechas convertidas y las claves cambiadas si se proporciona un mapeo.
     */
    public static function procesarArray($array, $mapeoNombres = null) {
        foreach ($array as &$item) {
            //$item['Suministros'] ='';
        //echo '<pre>'; print_r($item); die();
            
            /*foreach ($item as $key => $value) {
                if (self::esFormatoFecha($value)) {
                    $item[$key] = self::convertirFecha($value);
                }
            }*/
            if ($mapeoNombres !== null) {
                // Cambiar las claves si se proporciona un mapeo de nombres
                $item = self::renombrarClaves($item, $mapeoNombres);
            }
        }
        return $array;
    }



    /**
     * Verifica si un valor existe en una tabla Picklist y lo crea si no existe.
     *
     * @param string $campo - El nombre de la tabla Picklist.
     * @param string $valor - El valor que se desea verificar y crear si no existe.
     *
     * @return void
     */
    public static function VerificarAndCrearRegistroPicklist($campo, $valor, $uitype) {
        global $adb, $current_user;

        if( (string) $uitype ==='16' || (string) $uitype ==='15'){
            // Consulta para verificar si el valor ya existe
            $sql = "SELECT * FROM `vtiger_{$campo}` WHERE {$campo} = '{$valor}' LIMIT 1";
            $rs = $adb->pquery($sql);
            
            if (!$adb->num_rows($rs)) {

                if((string) $uitype ==='16'){
                // Inserción de un nuevo registro
                $insert = "INSERT INTO `vtiger_{$campo}` (`{$campo}id`, `{$campo}`, `sortorderid`, `presence`, `color`) VALUES (null, '{$valor}', 0, 1, '');";
                }

                if((string) $uitype ==='15'){
                    $sql = "SELECT picklist_valueid +1 as newvalue, sortorderid+1 as newsortorderid FROM `vtiger_{$campo}` ORDER BY picklist_valueid desc limit 1";
                    $rs = $adb->pquery($sql);
                    $newvalue = $adb->query_result($rs, 0, 'newvalue'); 
                    $newsortorderid = $adb->query_result($rs, 0, 'newsortorderid'); 
                    $insert = "INSERT INTO `vtiger_{$campo}` (`{$campo}id`, `{$campo}`, `presence`, `picklist_valueid`, `sortorderid`, `color`) VALUES (null, '{$valor}', 1, {$newvalue}, {$newsortorderid}, '');";
                }

                $rs = $adb->pquery($insert);
                $recordId = $adb->getLastInsertID();
                // Actualización de la secuencia
                $update = "UPDATE `vtiger_{$campo}_seq` SET `id` = $recordId LIMIT 1";
                $rs = $adb->pquery($update);
                //echo '<pre>'; print_r($campo); echo '<br>';print_r($key); echo '<br>'; print_r($valor); echo '</pre>';

            }
        }

    }

    /**
     * Obtener el id del usuario 
     *
     * @param [type] $username
     * @return void
     */
    public static function VT_UserExiste($username){
        global $adb, $current_user;
        $sql="SELECT id FROM vtiger_users WHERE user_name like '%{$username}%' limit 1";
        $rs = $adb->pquery($sql);
        $userid = $adb->query_result($rs, 0, 'id');

        return ($userid !='' )? $userid : '15';
        //return $adb->query_result($rs, 0, 'id'); 
    }

    /**
     * Restar y sumar dias a la fecha actual
     *
     * @param [string] $days
     * @return date
     */
    public static function SumarRestarDaysADate($days) {
        $currentDate = date('Y-m-d');
        $newDate = date('Y-m-d', strtotime($currentDate . ' ' . ($days >= 0 ? '+' : '-') . abs($days) . ' days'));
        return $newDate;
    }

    /**
     * Crear relacion de registro entre modulos 
     *
     * @param [type] $record 
     * @param [type] $relationId 
     * @return void
     */
    public static function addRelacionForIds($record, $relationId){
        $obj= (object) ['setRelation' => (object) [] ];
 		$relationModel = Vtiger_Relation_Model::getInstance(Vtiger_Record_Model::getInstanceById($record)->getModule(), Vtiger_Record_Model::getInstanceById($relationId)->getModule());
        $relationModel->addRelation($record,$relationId);

        $obj->setRelation->record     = $record;
        $obj->setRelation->relationId = $relationId;
        
        return $obj;
    }

    public static function deleRelacionForIds($field, $record){
        global $adb, $current_user;
        $obj= (object) ['setRelation' => (object) [] ];
        $current_user = Users::getActiveAdminUser();
        
        $sql = " SELECT prevalue FROM `vtiger_modtracker_detail` NATURAL join vtiger_modtracker_basic WHERE `fieldname` = '{$field}' and prevalue != '' and postvalue = '' and crmid ={$record} ORDER BY `id` DESC LIMIT 1";
        $rs         = $adb->pquery($sql);
        $row        = $adb->fetch_array($rs);
        $relationId = $row['prevalue'];
        //$adb->setDebug(1);
 		$relationModel = Vtiger_Relation_Model::getInstance(Vtiger_Record_Model::getInstanceById($record)->getModule(), Vtiger_Record_Model::getInstanceById($relationId)->getModule());
        $relationModel->deleteRelation($record,$relationId);

        $obj->setRelation->record     = $record;
        $obj->setRelation->relationId = $relationId;
        
        return $obj;
    }
    
    

    


    public static function getUserTokenStatic()
    {

        if(isset($_SESSION['scToken']) && $_SESSION['scToken']['lifetime'] > strtotime(date('Y-m-d H:i:s')))
        {
            $Token = $_SESSION['scToken']['token'];
            return $Token;
        }
        else{
        
            $param = [
                'segment' => 'interno/platafweb/autenticacion/AutenticacionInterna.svc/rest/ObtenerToken',
                'postBody' => [
                    "filtro" => [
                        "Usuario" => $_SESSION['ldsuser'],
                        "Password" => $_SESSION['rawPwd'],
                        "KeyDominio" => "LDS",
                        "Empresa" => "7"
                    ]
                ],
                
            ];

            #debug($param);
            $response = self::sendHTPP_request($param,"POST");
            #debug($response);
            if($response['http_status'] == 200)
            {
                $token = $response['body']['ObtenerTokenResult'];
                $Token = $token;
                $_SESSION['scToken']['lifetime'] = strtotime(date('Y-m-d H:i:s')) + $Token_lifespan;
                $_SESSION['scToken']['token'] = $Token;
            }
            else {
                $Token = '';
            }
        }

        return $Token;
    }



    public function vt_setModel($alldata, $module, $id = '',$source = 'EXTERNAL')
    {
        global $adb, $current_user;
        $mode = '';
        $current_user = Users::getActiveAdminUser();;
        
        if ($id) {
            $mode = 'edit';
            $model = Vtiger_Record_Model::getInstanceById($id); // internamente busca el módulo
            //return $id;
        } else {
            $mode = '';
            $model = Vtiger_Record_Model::getCleanInstance($module);
        }
        //var_dump($alldata);
        //$adb->setDebug(1);
        $model->set('mode', $mode); // lo preparas para el insert
        foreach ($alldata as $key => $value) {
            $model->set($key, $value);
        }

        $model->set('assigned_user_id', $alldata['assigned_user_id'] ?? '1');
        $model->set('source', $source);
        $model->save();
        return $model->getId();
    }

    //malmeyda 
    //Devuelve día español, mes español, 
    public function vt_convertDate($value){

        $fecha = new DateTime($value);

        //Obtenemos los datos del día
        $diaSemana = $fecha->format('w');
        $diaMes = $fecha->format('d');
        $diasSemana = [
            0 => 'Domingo',
            1 => 'Lunes',
            2 => 'Martes',
            3 => 'Miércoles',
            4 => 'Jueves',
            5 => 'Viernes',
            6 => 'Sábado'
        ];
        $dialetra = $diasSemana[$diaSemana];

        //Obtebemos los datos del mes
        $mes = $fecha->format('n');
        $meses = [
            1 => 'Enero',
            2 => 'Febrero',
            3 => 'Marzo',
            4 => 'Abril',
            5 => 'Mayo',
            6 => 'Junio',
            7 => 'Julio',
            8 => 'Agosto',
            9 => 'Septiembre',
            10 => 'Octubre',
            11 => 'Noviembre',
            12 => 'Diciembre'
        ];
        $mesletra = $meses[$mes];

        return [
                "date" => $value,
                "day" => $diaMes,
                "dayletter" => $dialetra,
                "month" => $mes,
                "monthletter" => $mesletra,
            ];
    }

}