<?php
chdir("../../../../");

include "complemento/config/confi.php";


vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');



function main($param)
{
    global $adb, $current_user,$document_root;
    $current_user = Users::getActiveAdminUser();

    switch ($param['action']) {
        case 'get_rel_fields':
            $moduleName = $param['module'];
            #Obtiene los campos relacionados
            $a = $adb->pquery("SELECT tabid FROM vtiger_tab WHERE name=? AND presence IN (0,2)",[$moduleName]);
            if($adb->num_rows($a) > 0)
            {
                $tabid = $adb->query_result($a,0,'tabid');
                $rq = $adb->pquery("SELECT fieldlabel,fieldid, fieldname FROM vtiger_field WHERE uitype IN(10) AND presence IN(0,2) AND tabid = ?",[$tabid]);
                if($adb->num_rows($rq) > 0)
                {
                    for ($i=0; $i < $adb->num_rows($rq); $i++) { 
                        $fieldid = $adb->query_result($rq,$i,'fieldid');
                        $result[$fieldid]['label'] = vtranslate(decode_html($adb->query_result($rq,$i,'fieldlabel')),$moduleName);
                        $result[$fieldid]['fieldname'] = $adb->query_result($rq,$i,'fieldname');
                        #Obtiene los módulos relaciones a los que tiene acceso
                        $as = $adb->pquery("SELECT relmodule FROM vtiger_fieldmodulerel WHERE fieldid = ? LIMIT 1",[$fieldid]);
                        if(!empty($adb->num_rows($as)))
                        {
                            $result[$fieldid]['relmodule'] = vtranslate(decode_html($adb->query_result($as,0,'relmodule')),$moduleName);
                            $result[$fieldid]['relmodule_'] = decode_html($adb->query_result($as,0,'relmodule'));
                            
                        }
                    }
                }
            }
            break;
        
        case 'get_customview':
            $relmodule = $param['module'];
            $fieldid = $param['fieldid'];
            #Obtiene las listas relacioandas para ese módulo
            $a = $adb->pquery("SELECT cvid, viewname FROM vtiger_customview WHERE entitytype=?",[$relmodule]);
            if($adb->num_rows($a) > 0)
            {
                for ($i=0; $i < $adb->num_rows($a); $i++) { 
                    $cvid = $adb->query_result($a,$i,'cvid');
                    $result['cv'][$cvid] = vtranslate(decode_html($adb->query_result($a,$i,'viewname')));
                }
                $a_ = $adb->pquery("SELECT cvid FROM complemento_fieldmodulerel WHERE fieldid = ? AND relmodule = ?",[$fieldid,$relmodule]);
                $result['saved_cv'] = $adb->query_result($a_,0,'cvid');
            }

            break;
        case 'save_field_customview':
            $cvid = $param['cvid'];
            $fieldid = $param['fieldid'];
            $relmodule = $param['relmodule'];
            $sa = $adb->pquery("SELECT 1 FROM complemento_fieldmodulerel WHERE fieldid = ? AND relmodule = ?",[$fieldid,$relmodule]);
            if($adb->num_rows($sa) > 0)
            {
                $adb->pquery("UPDATE complemento_fieldmodulerel SET cvid = ? WHERE fieldid = ? AND relmodule = ?",[$cvid,$fieldid,$relmodule]);
            }
            else{
                $adb->pquery("INSERT INTO complemento_fieldmodulerel VALUES (?,?,?)",[$fieldid,$relmodule,$cvid]);
            }
            
            break;
        case 'get_relatedfield_condition':

            $moduleName = $param['modulename'];
            $relmoduleName = $param['modulerel'];
            $n_fieldname = $param['n_fieldname'];
            #Obtiene los campos relacionados del módulo principal
            #$adb->setDebug(true);
            $a1 = $adb->pquery("SELECT vt.name, f.fieldid,f.fieldlabel,f.fieldname,vf.relmodule
            FROM vtiger_field f
                     JOIN vtiger_tab vt on f.tabid = vt.tabid
                     left JOIN vtiger_fieldmodulerel vf on f.fieldid = vf.fieldid
            WHERE vt.name = ?
              AND f.uitype in (10,51) AND f.fieldname <> ? AND f.presence IN(0,2);
            ",[$moduleName,$n_fieldname]);

            while ($row = $adb->fetch_array($a1)) {
                $row['t_fieldlabel'] = vtranslate($row['fieldlabel'],$row['name']);
                $result['fields']['module'][] = $row;
            }

            #Obtiene los campos relacionados del módulo relacionado
            $a2 = $adb->pquery("SELECT vt.name, f.fieldid,f.fieldlabel,f.fieldname,vf.relmodule
            FROM vtiger_field f
                     JOIN vtiger_tab vt on f.tabid = vt.tabid
                     left JOIN vtiger_fieldmodulerel vf on f.fieldid = vf.fieldid
            WHERE vt.name = ?
              AND f.uitype in (10,51) AND f.presence IN(0,2);
            ",[$relmoduleName]);

            while ($row = $adb->fetch_array($a2)) {
                $row['t_fieldlabel'] = vtranslate($row['fieldlabel'],$row['name']);
                $result['fields']['relmodule'][] = $row;
            }

            #Obtiene los campos configurados
            #$adb->setDebug(true);
            $s = $adb->pquery("SELECT * FROM complemento_fieldmodulerel_conditions WHERE module = ? AND modulerel = ? AND fieldname = ?",[$moduleName,$relmoduleName,$n_fieldname]);
            if(!empty($adb->num_rows($s)))
            {
                while ($row = $adb->fetch_array($s)) {
                    $result['config'][] = $row;
                }
            }

            break;
        case 'save_conditions' :
            $module = $param['module'];
            $relmodule = $param['relmodule'];
            $fieldname = $param['fieldname'];
            
            $r = $adb->pquery("DELETE FROM complemento_fieldmodulerel_conditions WHERE module = ? AND modulerel = ? AND fieldname = ? ",[$module,$relmodule,$fieldname]);
            if(is_object($r))
            {
                $result = [
                    'success' => true
                ];

                foreach ($param['condition_modulerel'] as $n => $fie) {
                    if(!empty($param['condition_module'][$n]) && !empty($param['condition_modulerel'][$n]))
                    {
                        $r = $adb->pquery("INSERT INTO complemento_fieldmodulere_conditions VALUES (?,?,?,?,?)",[$module,$relmodule,$fieldname,$param['condition_module'][$n],$param['condition_modulerel'][$n]]);
                        if(!$r)
                        {
                            $result = [
                                'success' => false
                            ];
                            break;
                        }
                    }
                }
            }
            else{
                $result = [
                    'success' => false
                ];
            }
            
            break;
            
    }
    

    echo json_encode($result);
}

main($_REQUEST);
?>