<?php
chdir("../../../../");
include "complemento/config/confi.php";

vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');

function set_vtranslate($fieldlabel,$module,$new_fieldlabel,$language)
{
    $qualifiedName = 'languages.'.$language.'.'.$module;
    $file = Vtiger_Loader::resolveNameToPath($qualifiedName);
    if(file_exists($file))
    {
        include($file);
        // Actualizar la traducción
        $languageStrings[$fieldlabel] = $new_fieldlabel;
    
        // Guardar los cambios en el archivo
        $contenido = '<?php' . PHP_EOL
                    . '$languageStrings = ' . var_export($languageStrings, true) . ';' . PHP_EOL
                    . '$jsLanguageStrings = ' . var_export($jsLanguageStrings, true) . ';';
    
        $success = file_put_contents($file, $contenido) ? true : false;
    }
   
    return $success;
}

function main($param)
{
    global $adb, $current_user,$document_root;
    $current_user = Users::getActiveAdminUser();

    switch ($param['action']) {
        case 'get_fields':
            $moduleName = $param['module'];
            #Obtiene los campos relacionados
            $a = $adb->pquery("SELECT tabid FROM vtiger_tab WHERE name=? AND presence IN (0,2)",[$moduleName]);
            if($adb->num_rows($a) > 0)
            {
                $tabid = $adb->query_result($a,0,'tabid');
                $rq = $adb->pquery("SELECT fieldlabel, fieldid, fieldname FROM vtiger_field WHERE presence IN(0,2) AND tabid = ?",[$tabid]);
                if($adb->num_rows($rq) > 0)
                {
                    for ($i=0; $i < $adb->num_rows($rq); $i++) { 
                        $fieldid = $adb->query_result($rq,$i,'fieldid');
                        $fieldlabel = $adb->query_result($rq,$i,'fieldlabel');
                        $result[$fieldid]['label_tranlated'] = Vtiger_Language_Handler::getTranslatedString(decode_html($adb->query_result($rq,$i,'fieldlabel')),$moduleName,$_GET['language']);
                        $result[$fieldid]['label_raw'] = decode_html($adb->query_result($rq,$i,'fieldlabel'));
                    }
                }
            }
            break;
        case 'set_translation':
            $current_user = Users::getActiveAdminUser();
            $success = set_vtranslate($_POST['fieldlabel'],$_POST['modulename'],$_POST['fieldtrans'],$_POST['language']);
            $result['result'] = $success;
            break;
        
            
    }

    echo json_encode($result);
}

main($_REQUEST);
?>