<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobile_WS_SendFeedback extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		$user_id = trim($request->get('user_id'));
		$message= $request->get('message');
		if(!empty($user_id) && !empty($message)){
			$userModel = Vtiger_Record_Model::getInstanceById($user_id,'Users');
			$first_name = $userModel->get('first_name');
			$last_name = $userModel->get('last_name');
			$contents = 'From : '.$first_name.' '.$last_name.'<br/>';
			$contents.= $message;

			$to_email = 'feedback@crmtiger.com';
			$from_name = $first_name.' '.$last_name;
			$from_email = $userModel->get('email1');
			$subject = 'Feedback Message';

			$mail = $this->send_mail($to_email,$from_name,$from_email,$subject,$contents);
			$response = new CTMobile_API_Response();
			if($mail == 1){
				$message = $this->CTTranslate('Your feedback submitted successfully');
				$response->setResult(array('code'=>'1','message'=>$message));
			}else{
				$message = $this->CTTranslate('Mail Not Sent');
				$response->setResult(array('code'=>'0','message'=>$message));
			}				 
			return $response;
		}else{
			$message = $this->CTTranslate('Your feedback is valuable for us - it cannot be empty');
			throw new WebServiceException(404,$message);
		}
	}


	function send_mail($to_email,$from_name,$from_email,$subject,$contents,$cc='',$bcc='',$attachment='',$emailid='',$logo='', $useGivenFromEmailAddress=false,$useSignature = 'Yes',$inReplyToMessageId=''){

		$fromEmail = $this->getFromEmailAddress();
		$replyTo = $this->getReplyToEmail();
		
		$mail = Emails_Mailer_Model::getInstance();
		$mail->IsHTML(true);
		$mail->ConfigSenderInfo($fromEmail, $from_name, $replyTo);
		$mail->Subject = $subject;
		//Added back as we have changed php mailer library, older library was using html_entity_decode before sending mail
		$mail->Body = decode_html($contents);
		$plainBody = decode_html($contents);
		$plainBody = preg_replace(array("/<p>/i","/<br>/i","/<br \/>/i"),array("\n","\n","\n"),$plainBody);
		$plainBody = strip_tags($plainBody);
		$plainBody = Emails_Mailer_Model::convertToAscii($plainBody);
		$mail->AltBody = $plainBody;
		
		
	
		$mail->AddAddress($to_email);
		
		$status = $mail->Send(true);
		
		if(!$status) {
			$mail_error = $mail->getError();
		}else{
			$mail_error = $status;
		}
		
		return $mail_error;
  	}

  	function getFromEmailAddress() {
		$db = PearDatabase::getInstance();
		$currentUserModel = Users_Record_Model::getCurrentUserModel();

		$fromEmail = false;
		$result = $db->pquery('SELECT from_email_field FROM vtiger_systems WHERE server_type=?', array('email'));
		if ($db->num_rows($result)) {
			$fromEmail = decode_html($db->query_result($result, 0, 'from_email_field'));
		}
		if (empty($fromEmail)) $fromEmail = $currentUserModel->get('email1');
		return $fromEmail;
	}

	function getReplyToEmail() {
		$db = PearDatabase::getInstance();
		$defaultReplyTo = vglobal('default_reply_to');
		$currentUserModel = Users_Record_Model::getCurrentUserModel();
		$replyTo = $currentUserModel->get('email1');

		if ($defaultReplyTo == 'outgoing_server_from_email') {
			$result = $db->pquery('SELECT from_email_field FROM vtiger_systems WHERE server_type=?', array('email'));
			if ($db->num_rows($result)) {
				$fromEmail = decode_html($db->query_result($result, 0, 'from_email_field'));
			}
			if (!empty($fromEmail)) {
				$replyTo = $fromEmail;
			}
		} else if ($defaultReplyTo == 'hepldesk_support_email') {
			$helpDeskEmail = vglobal('HELPDESK_SUPPORT_EMAIL_ID');
			if (!empty($helpDeskEmail)) {
				$replyTo = $helpDeskEmail;
			}
		}

		return $replyTo;
	}
	
}
