<?php

class CTMobile_WS_PriceBooksList extends CTMobile_WS_Controller {

    function process(CTMobile_API_Request $request) {
        $default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
        global $current_user, $adb;
        $current_user = $this->getActiveUser();

        $ParentRecord = explode('x',$request->get('sourceRecord'));
        $sourceModule = $request->get('sourceModule');
        $sourceRecord = $ParentRecord[1];

        $isactivestatus = trim($request->get("isactive"));
        if($isactivestatus == ""){
        	$isactivestatus = true;
        }
        $index = trim($request->get("index"));
        $size = trim($request->get("size"));
        $record = trim($request->get("record"));
        $field_name = trim($request->get('field_name'));
        $field_value = trim($request->get('field_value'));
        $record_id = explode('x', $record);
        $recordId = $record_id[1];

        if($index == ''  || $index == 0){
            $index = 1;
        }



        if ($sourceRecord == '') {
            $message = $this->CTTranslate('Required fields not found');
            throw new WebServiceException(404, $message);
        }
        $moduleFields = array('id','bookname','active');
        if($field_name){
			$moduleFields = array_merge($moduleFields,Zend_JSON::decode($field_name));
		}
		$modulename = 'PriceBooks';
		$moduleModel = Vtiger_Module_Model::getInstance($modulename);
        $fieldModels = $moduleModel->getFields();

        $entityQuery = $adb->pquery("SELECT * FROM vtiger_entityname WHERE modulename = ?",array($modulename));
		$entityField = $adb->query_result($entityQuery,0,'fieldname');
		$entityField_array = explode(',',$entityField);
		$entityField = $entityField_array[0];
		$tabid = getTabid($modulename);
		
		$entityQuery11 = $adb->pquery("SELECT * FROM vtiger_field WHERE columnname = ? and tabid= ?",array($entityField,$tabid));
		$fieldlabel = $adb->query_result($entityQuery11,0,'fieldlabel');
		$fieldlabel = vtranslate($fieldlabel,$modulename);

		$fields = $fieldModels[$entityField];
		$result = $adb->pquery("SELECT fieldtype FROM vtiger_ws_fieldtype WHERE uitype = ?",array($fields->get('uitype')));
		$fieldtype = $adb->query_result($result, 0, 'fieldtype');
		if(!$fieldtype){
			$typeofdata = explode('~',$fields->get('typeofdata'));
			switch($typeofdata[0]){
				case 'T': $fieldtype = "time";
				case 'D': $fieldtype = "date";
				case 'DT': $fieldtype =  "date";
				case 'E': $fieldtype =  "email";
				case 'N':
				case 'NN': $fieldtype = "double";
				case 'P': $fieldtype = "password";
				case 'I': $fieldtype = "integer";
				case 'V':
				default: $fieldtype = "string";
			}
		}
		if($fields->get('uitype') == 15 || $fields->get('uitype') == 33){
			$picklistValues1 = array();
			$picklistValues = Vtiger_Util_Helper::getRoleBasedPicklistValues($fields->get('name'),$roleid);
			foreach($picklistValues as $pvalue){
				$picklistValues1[] = array('value'=>$pvalue, 'label'=>vtranslate($pvalue,$modulename));
			}
			
			$entityFields = array('name'=>$fields->get('name'),'label'=>vtranslate($fields->get('label'),$modulename),'type'=>array('picklistValues'=>$picklistValues1,'name'=>$fieldtype,'defaultValue'=>$fields->getDefaultFieldValue()),'editable'=>$fields->isEditable(),'mandatory'=>$fields->isMandatory(),'isunique'=>$fields->get('isunique'), 'readonly'=>$fields->get('readonly'),'displaytype'=>$fields->get('displaytype'),'typeofdata'=>$fields->get('typeofdata'),'uitype'=>$fields->get('uitype'),'summaryfield'=>$fields->get('summaryfield'),'presence'=>$fields->get('presence'));
		}else{
			$entityFields = array('name'=>$fields->get('name'),'label'=>vtranslate($fields->get('label'),$modulename),'type'=>array('name'=>$fieldtype,'defaultValue'=>$fields->getDefaultFieldValue()),'mandatory'=>$fields->isMandatory(),'editable'=>$fields->isEditable(),'isunique'=>$fields->get('isunique'),'readonly'=>$fields->get('readonly'),'displaytype'=>$fields->get('displaytype'),'typeofdata'=>$fields->get('typeofdata'),'uitype'=>$fields->get('uitype'),'summaryfield'=>$fields->get('summaryfield'),'presence'=>$fields->get('presence'));
		}

        if ($isactivestatus == true) {
            $queryGenerator = new QueryGenerator($moduleModel->get('name'), $current_user);
            $queryGenerator->setFields($moduleFields);
            $query = $queryGenerator->getQuery();

            if($field_name && $field_value){
				$field_names = Zend_JSON::decode($field_name);
				$field_values = Zend_JSON::decode($field_value);
				
				foreach ($field_names as $key => $field_name) {
					$field_value = addslashes(trim($field_values[$key]));
					$tablename = $columnByFieldNames[$field_name]['table'];
					if($field_name){
						$uitype = $fieldModels[$field_name]->get('uitype');
						$typeofdata = explode('~',$fieldModels[$field_name]->get('typeofdata'));
					}
					$refrenceUitypes = array(10,51,57,58,59,66,73,75,76,77,78,80,81,101);
					if($module == 'Documents' && $fieldname == 'folderid'){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$fieldValue = explode('x',$field_value);
						$query .= " AND ".$tablename.".".$column." = '".$fieldValue[1]."'";
					}else if($module == 'PriceBooks' && $fieldname == 'currency_id'){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$fieldValue = explode('x',$field_value);
						$query .= " AND ".$tablename.".".$column." = '".$fieldValue[1]."'";
					}else if(in_array($uitype,$refrenceUitypes)){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$fieldValue = explode('x',$field_value);
						$query .= " AND ".$tablename.".".$column." = '".$fieldValue[1]."'";
					}else if($field_name == 'assigned_user_id'){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$fieldValue = explode('x',$field_value);
						$query .= " AND ".$tablename.".".$column." = '".$fieldValue[1]."'";
					}else if($uitype == 33){
						$fieldvalues = explode(',', $field_value);
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$query.= " AND (( ";
						foreach ($fieldvalues as $key => $fieldValue) {
							if($key+1 == count($fieldvalues)){
								$query.= " ".$tablename.".".$column." LIKE '%".$fieldValue."%' ";
							}else{
								$query.= " ".$tablename.".".$column." LIKE '%".$fieldValue."%' OR ";
							}
						}
						$query.= " )) ";
					}else if(in_array($uitype, array(5,6,23,70))){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$fieldValue = explode(",",$field_value);
						if($uitype == 70){
							$date1 = Vtiger_Datetime_UIType::getDBDateTimeValue($fieldValue[0].' 00:00:01');
							$date2 = Vtiger_Datetime_UIType::getDBDateTimeValue($fieldValue[1].' 23:59:00');
							$query.= " AND ".$tablename.".".$column." BETWEEN '".$date1."' AND '".$date2."'";
						}else{
							$date1 = $nowInDBFormat = Vtiger_Date_UIType::getDBInsertedValue($fieldValue[0]);
							$date2 = $nowInDBFormat = Vtiger_Date_UIType::getDBInsertedValue($fieldValue[1]);
							$query.= " AND DATE(".$tablename.".".$column.") BETWEEN '".$date1."' AND '".$date2."'";
						}
						
					}else if($typeofdata[0] == 'T'){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						if($module == 'Calendar' || $module == 'Events'){
							$date = Vtiger_Date_UIType::getDisplayDateValue(date('Y-m-d'));
							$nowInUserFormat = $date.' '.$field_value;
							$nowInDBFormat = Vtiger_Datetime_UIType::getDBDateTimeValue($nowInUserFormat);
							$dateTime = explode(' ',$nowInDBFormat);
							$query.= " AND ".$tablename.".".$column." = '".$dateTime[1]."'";
						}else{
							$dateTime =  Vtiger_Time_UIType::getTimeValueWithSeconds($field_value);
							$query.= " AND ".$tablename.".".$column." = '".$dateTime."'";
						}
					}else if(in_array($uitype, array(71,72))){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$query .= " AND ".$tablename.".".$column." = '".$field_value."'";
					}else if($uitype == 117){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$fieldValuee = explode('x', $field_value);
						$query .= " AND ".$tablename.".".$column." = '".$fieldValuee[1]."'";
					}else if($field_name == 'taskstatus' || $field_name == 'taskstatus'){
						$query .= " AND ((vtiger_activity.status = '$field_value' ) OR (vtiger_activity.eventstatus = '$field_value' )) ";
					}else if($uitype == 15 || $uitype == 16){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$query .= " AND ".$tablename.".".$column." = '".$field_value."'";
					}else{
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						if($field_name2 != '' && $field_value2 != ''){
							$query .= " AND ".$tablename.".".$column." = '".$field_value."'";
						}else{
							if($searchType != '' && $searchType == 'barcode'){
								$query .= " AND ".$tablename.".".$column." = '".$field_value."'";
							}else{
								$query .= " AND ".$tablename.".".$column." LIKE '%".$field_value."%'";
							}
						}
					}
				}
			}

           /* if(method_exists($moduleModel, 'getQueryByModuleField')) {
                $overrideQuery = $moduleModel->getQueryByModuleField($sourceModule, '', $sourceRecord, $query, '6');
            }else{
                $overrideQuery = $query;
            }*/
            $overrideQuery = $query;

            if($index && $size){
                $limit = ($index*$size) - $size;
                $overrideQuery.=" LIMIT $limit,$size";
            }
            
            $result = $adb->pquery($overrideQuery);
            $numOfRows =  $adb->num_rows($result);
            $product_detail = array();
            $pricebook_name = '';
            for ($i=0; $i < $numOfRows; $i++) { 
                $row = $adb->query_result_rowdata($result,$i);
                if($row['active'] == 1){
                    $active = vtranslate('LBL_YES');
                }else{
                    $active = vtranslate('LBL_NO');
                }
                $pricebooksid = $row['pricebookid'];
                $recordModel = Vtiger_Record_Model::getInstanceById($pricebooksid,$modulename);
                $row['listprice'] = $recordModel->getProductsListPrice($sourceRecord);
                if($row['listprice']){
                    $product_detail[] = array('id'=>$pricebooksid,'pricebookid'=>$pricebooksid,'label'=>$row['bookname'],'bookname'=>$row['bookname'],'listprice'=>$row['listprice'],'active'=>$active);
                }
            }
            $moduleLabel = vtranslate($modulename,$modulename);
            $response = new CTMobile_API_Response();
            $response->setResult(array('records'=>$product_detail,'module'=>$modulename,'moduleLabel'=>$moduleLabel,'entityField'=>$entityFields));
            return $response;
        }else{
        	$response = new CTMobile_API_Response();
            $message = $this->CTTranslate('Invalid status');
            $response->setError(404, $message);
            return $response;
        }
    }
}
