<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobile_WS_GetTimeTrackingDetails extends CTMobile_WS_Controller {

	function process(CTMobile_API_Request $request) {
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		global $current_user, $adb; 
		$current_user = $this->getActiveUser();

		$record = trim($request->get('record'));
		
		if($record == ""){
			$message =  $this->CTTranslate('Required fields not found');
			throw new WebServiceException(404,$message);
		}

		$record_id = explode('x',$record);
		$recordId = $record_id[1];
		$module = 'CTTimeTracker';

		$recordPermission = Users_Privileges_Model::isPermitted($module, 'DetailView', $recordId);
		if(!$recordPermission) {
			throw new WebServiceException(403,vtranslate('LBL_PERMISSION_DENIED'));
		}

		$getTimetrackingSQL = "SELECT * FROM  vtiger_cttimetracker INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_cttimetracker.cttimetrackerid WHERE vtiger_cttimetracker.cttimetrackerid = ?";
		
        $result = $adb->pquery($getTimetrackingSQL, array($recordId));
        $num_rows = $adb->num_rows($result);

        $timetrackinglists = array();
        for($i=0; $i<$num_rows; $i++) {
            $row = $adb->fetchByAssoc($result, $i);
            $related_to = $row['related_to'];
            $getModuleLabel = $adb->pquery("SELECT * FROM vtiger_crmentity WHERE deleted = 0  AND crmid = ?",array($related_to));
            $relatedto = array();
            if($adb->num_rows($getModuleLabel)){
            	$setype = $adb->query_result($getModuleLabel,0,'setype');
            	$label = $adb->query_result($getModuleLabel,0,'label');
            	$relatedto = array("id"=>$related_to,'label'=>$label,'modulename'=>$setype);
            	$related_to = CTMobile_WS_Utils::getEntityModuleWSId($setype).'x'.$related_to;
            }

            if($row['tracking_user']){
            	$UserRecordModel = Users_Record_Model::getInstanceById($row['tracking_user'],'Users');
            	$tracking_user = array("id"=>CTMobile_WS_Utils::getEntityModuleWSId('Users').'x'.$row['tracking_user'],'label'=>$UserRecordModel->get('first_name').' '.$UserRecordModel->get('last_name'));
            }
	            	
	        $timetrackinglists[] = array('cttimetrackerid'=>$row['cttimetrackerid'],'tracking_title'=>decode_html(decode_html($row['tracking_title'])),'timetracker_no'=>$row['timetracker_no'],'tracking_user'=>$tracking_user,'tracking_notes'=>$row['tracking_notes'],'tracking_status'=>$row['tracking_status'],'total_time'=>$row['total_time'],'total_hour'=>$row['total_hour'],'total_min'=>$row['total_min'],'total_seconds'=>$row['total_seconds'],'related_to'=>$relatedto);
	       
        }
		$response = new CTMobile_API_Response();
		$moduleLabel = vtranslate($module,$module);
		if(count($timetrackinglists) == 0) {
			$message = $this->CTTranslate('No records found');
			$response->setResult(array('records'=>$timetrackinglists,'message'=>$message));
		} else {
			$response->setResult(array('records'=>$timetrackinglists,'message'=>''));
		}
		return $response;
	}
}