<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
class CTMobileSettings_ValidateApi_Action extends Vtiger_Save_Action {
    
public function process(Vtiger_Request $request) {
	global $adb,$site_URL;
	$api_Key = trim($request->get('api_Key'));
	$getLicenseQuery=$adb->pquery("SELECT * FROM ctmobile_api_settings");
	$numOfLicenseCount = $adb->num_rows($getLicenseQuery);
	
	$address = "203 - Prerna Arcade, Parimal Underbridge, Ellisbridge, Tulsibag Society, Ambawadi, Ahmedabad, Gujarat 380006";
	$address=urlencode($address);
	
	$data = array();
	$opts = array('http'=>array('header'=>"User-Agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.146 Safari/537.36\r\n"));
	$context = stream_context_create($opts);
	$formattedAddr = str_replace(' ','+',$address);
	//Send request and receive json data by address
	$url = 'https://maps.googleapis.com/maps/api/geocode/json?address='.$formattedAddr.'&key='.$api_Key;
	
	$curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => $url,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_USERAGENT => "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.146 Safari/537.36"
    ));
    $geocodeFromAddr = curl_exec($curl);
    curl_close($curl);

	$output = json_decode($geocodeFromAddr);
	$status = $output->status;
	if($status === 'OK'){
		$result = array('code'=>1, 'msg'=>vtranslate('Google Api Key is valid','CTMobileSettings'));
	}else{
		$result = array('code'=>100, 'msg'=>vtranslate($output->error_message,'CTMobileSettings'));
	}
	$response = new Vtiger_Response();
	$response->setEmitType(Vtiger_Response::$EMIT_JSON);
	$response->setResult($result);
	$response->emit();
}
}
?>
