<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">

    <title>Gestionar Dashboard y Permisos</title>
  </head>
  <body>
    <div class="d-flex justify-content-center">
        <div class="card">
        <h5 class="card-header">CREAR permisos y dashboard de los Estudiantes</h5>
        <div class="card-body">
        <form class="container center row g-3 " action="index.php" method="POST">
            <input type="hidden" name="ejecutar" value="estudiante">
            <div class="col-sm-12">
                <label class="visually-hidden" for="specificSizeSelect">Rol</label>
                <select class="form-select" name="rolename" id="rolename">
                    <option value="" disabled >Seleccionar rol</option>
                    <option value="Gerente  B2C" >Gerente B2C (2 espacio)</option>
                    <option value="Gerente B2C" >Gerente B2C</option>
                    <option value="Gerente B2B" >Gerente B2B</option>
                    <option value="Gerente  B2B" >Gerente B2B (2 espacio)</option>
                </select>
            </div>
            <div class="col-12 mb-3">
                <button  type="submit" class="btn btn-primary">Enviar</button> 
            </div>
        </form>
        </div>
        </div>

        <div class="card">
        <h5 class="card-header">BORRAR permisos y dashboard de los Estudiantes</h5>
        <div class="card-body">
        <form class="container center row g-3 " action="index.php" method="GET">
            <input type="hidden" name="ejecutar" value="deleteAll">
            <div class="col-12 mb-3">
                <input type="submit" value="BORRAR" class="btn btn-warning">
            </div>
        </form>
        </div>
        </div>
    </div>



    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p" crossorigin="anonymous"></script>


  </body>
</html>



<?php
ini_set('display_errors','on'); error_reporting(E_ALL); // STRICT DEVELOPMENT

chdir("../../");
require_once 'data/CRMEntity.php';
include_once 'includes/main/WebUI.php';
include_once 'vtlib/Vtiger/Module.php';
require_once 'includes/Loader.php';
require_once 'include/utils/utils.php';
require_once 'config.inc.php';

vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');

//ini_set('max_execution_time', 0);
//set_time_limit(0);


define('_SERVER',$dbconfig['db_server']);
define('_DB',$dbconfig['db_name']);
define('_USER',$dbconfig['db_username']);
define('_PASS',$dbconfig['db_password']);

//  PDO CONECTION
	function Conectar(){
        try {
            $mysql='mysql:host='._SERVER. ';dbname='._DB.';charset=utf8';
            $cn = new PDO($mysql, _USER,_PASS);
            $cn->exec("set names utf8");
            return $cn;
        } catch (Exception $e) {
            echo "Failed: " . $e->getMessage();
        }
	}


    /**
     * 
     */
    function deleteAllDataForCondition()
    {
        $con = Conectar();
        $delobj  = new stdClass();
        # Pasar Variable al Objeto

        $false = $true = 0;
        $delobj->query = " SELECT userid, user_name, first_name, last_name, reports_to_id, email1, userlabel, rolename, vtiger_role.roleid,  ";
        $delobj->query.= " IF(rolename like '%Gerentes de ventas%', 'B2B', IF(rolename like '%Jefe%', 'B2C','')) as categoria ";
        $delobj->query.= " FROM `vtiger_users`  ";
        $delobj->query.= " INNER JOIN vtiger_user2role on vtiger_users.id = vtiger_user2role.userid  ";
        $delobj->query.= " INNER JOIN vtiger_role on vtiger_role.roleid = vtiger_user2role.roleid ";
        $delobj->query.= " WHERE vtiger_users.email1='dummy@test.com' and (rolename LIKE '%Gerentes de ventas%' or rolename LIKE '%Jefe%'); ";

        $stmt = $con->prepare($delobj->query);
        $stmt->execute();

    
    
        # Verificar => si tengo registro en DB && si la rolename es B2B o B2C 
        if( $delobj->rowCount = ($stmt->rowCount()) ){
    
    
            while ($row = $stmt->fetch(PDO::FETCH_OBJ)) 
            {
                # Eliminar shareusers del usuario
                $del_register .= "DELETE FROM `vtiger_report_shareusers` WHERE `userid`='$row->userid'; ";
                # Eliminar widgets del usuario
                $del_register .= "DELETE FROM `vtiger_module_dashboard_widgets` WHERE `userid`='$row->userid'; ";
                # Eliminar tabs del usuario
                $del_register.= "DELETE FROM `vtiger_dashboard_tabs` WHERE `userid`='$row->userid' and (`tabname` like '%CASO%'); ";
                
            }
            $delobj->sqldelete = $del_register;
            $stmt = $con->prepare($del_register);
            $resp = $stmt->execute();
            
        }
    
        echo json_encode($delobj);
        return $delobj;
    }



    /**
     * 
     */
    function createTapDashboardEstudiante($get)
    {
        if($get->rolename == '' && $get->cantTaps == '') return false;
        global $adb;
        $objx  = new stdClass();
        $objx->get = $get;
        # Pasar Variable al Objeto
        $objx->rolename = $get->rolename;
        $objx->ejecutar = $get->ejecutar;
        $objx->cantTaps = (int) $get->cantTaps;
        $objx->grupo = (int) $get->grupo;
        //$objx->B2       = buscarPalabra($objx->rolename);
        $objx->rango    = range(1, $objx->cantTaps );
    
        $objx->action   = 'obtenerUsersForRolenameHijo'; createSQL($objx);
        $objx->querySeach = $objx->query;
        $res            = $adb->pquery($objx->query);
        $objx->sqlcount = $adb->num_rows($res);
        //print_r($objx); die();
    
    
        # Verificar => si tengo registro en DB && si la rolename es B2B o B2C 
        if( $objx->sqlcount )
            while ($row = $adb->fetch_array($res)) 
            {
    
        
                    # Obtener el numero siguiente de la secuencia por el usuario
                    $objx->userid = $row['userid'];
                    $objx->B2     = $row['categoria']; // B2B or B2C
                    $objx->rolename     = $row['rolename'];
                    $objx->user_name     = $row['user_name'];
                    $objx->action = 'dashboardTabsMaxUser'; createSQL($objx);
                    $objx->query;
                    $result       = $adb->pquery($objx->query);
                    $row2         = $adb->query_result_rowdata($result);
                    $objx->max    = $row2['max'];
                    $objx->rolnamenum= quitarLetrasYEspacios($objx->rolename);
                    $objx->rolname->grupo = $objx->rolnamenum[0];
                    $objx->rolname->tap = $objx->rolnamenum[1];
                    // print_r($objx); die();
                
                    # Crear los insert para la tabla 'vtiger_dashboard_tabs'
                //if($objx->userid == 283)// Usuario de prueba
                    if($objx->B2 =='B2C')
                    //if($objx->B2 !='')
                    {
    
                        $objx->tabname  = 'CASO '.$objx->B2.'-'.formatoNumero($objx->rolname->tap);
                        
    
                        $objx->action    = 'verfTapAlCrear'; createSQL($objx);
                        $objx->querySeach2= $objx->query;
                        $resultAlCrear          = $adb->pquery($objx->query);
                        //print_r($objx); die();
    
                        if($adb->num_rows($resultAlCrear)==0 ){
                            $objx->qInsert1 = '';
                            $objx->action   = 'createTaps';
                            createSQL($objx);
                            $objx->qInsert1= $objx->query;
    
                            $objx->result   = $adb->pquery($objx->qInsert1);
                            $objx->newid    = $adb->getLastInsertID();
                            addGraficTap($objx);// Asignar graficas al taps del dashboard
                            //print_r($objx); die();
    
                            $objx->countInsert++;
                        }
                        $objx->max++;
                    }
                //}//user test
            }
            echo '<pre>'; print_r($objx); echo '</pre>';
        return $objx;
    }




















function createSQL($objx)
{
    switch ($objx->action) {
        case 'obtenerUsersForRolenamePadre':
            $objx->query = " SELECT userid, user_name, first_name, last_name, reports_to_id, email1, userlabel, rolename, vtiger_role.roleid FROM `vtiger_users` ";
            $objx->query.= " INNER JOIN vtiger_user2role on vtiger_users.id = vtiger_user2role.userid ";
            $objx->query.= " INNER JOIN vtiger_role on vtiger_role.roleid = vtiger_user2role.roleid ";
            $objx->query.= " WHERE rolename like '%$objx->rolename%'; ";
            break;
        case 'dashboardTabsMaxUser':
            $objx->query = " SELECT max(sequence+1)as max from vtiger_dashboard_tabs WHERE userid='$objx->userid'; ";
            break;
        case 'createTaps':
            $objx->query = " INSERT INTO `vtiger_dashboard_tabs` (`id`, `tabname`, `isdefault`, `sequence`, `appname`, `modulename`, `userid`) ";
            $objx->query.= " VALUES (null, '$objx->tabname', 0, $objx->max, NULL, NULL, $objx->userid); ";
            break;
        case 'verfTapAlCrear':
            $objx->query =" SELECT id, tabname from vtiger_dashboard_tabs WHERE tabname='$objx->tabname' and userid='$objx->userid'; ";
            break;
        case 'getSeq':
            $objx->query =" SELECT max(id) as seqmax from vtiger_dashboard_tabs";
        break;
        case 'obtenerUsersForRolenameHijo':
            $objx->query = " SELECT userid, user_name, first_name, last_name, reports_to_id, email1, userlabel, rolename, vtiger_role.roleid,  ";
            $objx->query.= " IF(rolename like '%Gerentes de ventas%', 'B2B', IF(rolename like '%Jefe%', 'B2C','')) as categoria ";
            $objx->query.= " FROM `vtiger_users`  ";
            $objx->query.= " INNER JOIN vtiger_user2role on vtiger_users.id = vtiger_user2role.userid  ";
            $objx->query.= " INNER JOIN vtiger_role on vtiger_role.roleid = vtiger_user2role.roleid ";
            $objx->query.= " WHERE vtiger_users.email1='dummy@test.com' and (rolename LIKE '%Gerentes de ventas%' or rolename LIKE '%Jefe%'); ";
        break;
        case 'deleteuserEstudiante':
            $objx->query = " SELECT * from vtiger_module_dashboard_widgets 
            INNER JOIN vtiger_dashboard_tabs on vtiger_dashboard_tabs.id = vtiger_module_dashboard_widgets.dashboardtabid  WHERE vtiger_module_dashboard_widgets.userid='107'; ";
        break;


    }
    return $objx;
}






function createTapDashboardProf($get)
{
    if($get->rolename == '' && $get->cantTaps == '') return false;
    global $adb;
    $objx  = new stdClass();
    # Pasar Variable al Objeto
    $objx->rolename = $get->rolename;
    $objx->ejecutar = $get->ejecutar;
    $objx->cantTaps = (int) $get->cantTaps;
    $objx->B2       = buscarPalabra($objx->rolename);
    $objx->rango    = range(1, $objx->cantTaps );

    $objx->action   = 'obtenerUsersForRolenamePadre'; createSQL($objx);
    //echo $objx->query;
    $res            = $adb->pquery($objx->query);
    $objx->sqlcount = $adb->num_rows($res);
    //print_r($objx); die();


    # Verificar => si tengo registro en DB && si la rolename es B2B o B2C 
    if( $objx->sqlcount !='' && $objx->B2 != false )
    {
        while ($row = $adb->fetch_array($res)) 
        {
            # Obtener el numero siguiente de la secuencia por el usuario
            $objx->userid = $row['userid'];
            $objx->action = 'dashboardTabsMaxUser'; createSQL($objx);
            $result       = $adb->pquery($objx->query);
            $row2         = $adb->query_result_rowdata($result);
            $objx->max    = $row2['max'];
            //print_r($objx); die();
            
                # Crear los insert para la tabla 'vtiger_dashboard_tabs'
                //if($objx->userid == 109) // Usuario de prueba
                //if($objx->userid == 109) // Usuario de prueba
                foreach ( $objx->rango as $key => $value) 
                {
                    $objx->tabname  = 'CASO '.$objx->B2.'-'.formatoNumero($value);

                    $objx->action    = 'verfTapAlCrear'; createSQL($objx);
                    $result          = $adb->pquery($objx->query);
                    $adb->query_result_rowdata($result);
                    //print_r($objx); die();
                    
                    # Verifico si no hay tablero
                    if(!$adb->num_rows($result) ){
                        $objx->qInsert1 = '';
                        $objx->action   = 'createTaps';
                        $objx->qInsert1 = createSQL($objx)->query;
                        $objx->result   = $adb->pquery($objx->qInsert1);
                        $objx->newid    = $adb->getLastInsertID();
                        addGraficTap($objx);// Asignar graficas al taps del dashboard
                        $objx->countInsert++;
                       // print_r($objx); die();
                    }
                    $objx->max++;
                }
            //print_r($objx); die();
        }
    }
    return $objx;
}//END function


















    function addGraficTap($objx){
    global $adb;
    
            // userid = 1 => administrador tiene todos los tableros configurados par  B2B
            // userid = 110 => profesor tiene todos los tableros configurados par B2C 
            if($objx->B2=='B2B'){
                $useridEjemplo = 1;
            }elseif($objx->B2=='B2C'){
                $useridEjemplo = 110;
            }

            
            if($useridEjemplo !='' && $objx->tabname !='' && $objx->newid !='' && $objx->userid !=''){
                $objx->queryGraf = "INSERT INTO vtiger_module_dashboard_widgets (linkid, userid, filterid, title, `data`, position, reportid, dashboardtabid, size)
                SELECT 0 as linkid, '$objx->userid' as userid, filterid, title, vtiger_module_dashboard_widgets.`data`, position, reportid, '$objx->newid'as dashboardtabid, size FROM vtiger_module_dashboard_widgets natural join vtiger_report 
                natural JOIN vtiger_report_shareusers WHERE vtiger_module_dashboard_widgets.userid = '$useridEjemplo' and reportname like '%$objx->tabname%';";

                $adb->pquery($objx->queryGraf);
                $newid = $adb->getLastInsertID();
                if($newid!=0){
                    
                }
                $objx->id_vtiger_module_dashboard_widgets[] = array('userid' => $objx->userid,'dashboardtabid' => $objx->newid, 'dashboardtabid' => $objx->tabname, 'user_n ame' => $objx->user_name  );


                # Adignar permisos a la grafica al usuario estudiante
                if($objx->ejecutar =='estudiante')
                insertarRegistrosFaltantesdelUsuario($objx->userid);
            }
    return $objx;
}



function ComprobarPermisosUser($objx) {
    global $adb;
    $objx->query="SELECT reportid, userid  FROM vtiger_module_dashboard_widgets WHERE  userid ='$objx->userid';";
    $result = $adb->pquery($objx->query);
    if(!$adb->num_rows($result) ){
        while ($row = $adb->fetch_array($res)){

        }

    }
}


function insertarRegistrosFaltantesdelUsuario($userid) {
    global $adb;

    
    // Obtener reportids existentes de la tabla vtiger_report_shareusers
    $reportesExistentes = [];
    $query = "SELECT reportid FROM vtiger_report_shareusers WHERE userid = '{$userid}'; ";
    $result2 = $adb->pquery($query);
    while ($row2 = $adb->fetch_array($result2)) {
        $reportesExistentes[] = $row2['reportid'];
    }
    
    // Seleccionar reportids de la tabla vtiger_module_dashboard_widgets
    $query = "SELECT reportid FROM vtiger_module_dashboard_widgets WHERE userid = '{$userid}'; ";
    $result = $adb->pquery($query);

    // Insertar reportids faltantes
    while ($row = $adb->fetch_array($result)) {
        if (!in_array($row['reportid'], $reportesExistentes)) {
            $queryInsert = "INSERT INTO vtiger_report_shareusers (reportid, userid) VALUES ('{$row['reportid']}', '{$userid}'); ";
            $adb->pquery($queryInsert);
        }
    }
}




function buscarPalabra($cadena, $palabra = ['B2C', 'B2B']) {
    $palabras = explode(" ", $cadena);
    $palabra = array_map('strtolower', (array)$palabra);
    
    foreach ($palabras as $p) {
        if (in_array(strtolower($p), $palabra)) {
            return $p;
        }
    }
    return false;
}





function formatoNumero($numero) {
    return ($numero < 10)? '0' . $numero : $numero ;
}



function obtenerRow($objx){
    if($objx->action == '') return false;
    global $adb;
    createSQL($objx);
    $result = $adb->pquery($objx->query);
    if($adb->num_rows($result))
    while ($row = $adb->fetch_array($res)){
        $result.=$row;
    }
    return $result;
}

function quitarLetrasYEspacios($cadena) {
    // Eliminar todos los caracteres excepto los números y los caracteres especiales
    $cadena = preg_replace("/[^0-9\-\+\(\)\*]/", "", $cadena);
    return $cadena;
}


$get  = new stdClass();


$get->rolename = $_REQUEST['rolename'];
//$get->rolename = 'Gerente B2C';
//$get->rolename = 'Gerente B2B';
//$get->rolename = 'Gerente  B2B';
$get->cantTaps = $_REQUEST['cantTaps'];
$get->ejecutar = $_REQUEST['ejecutar'];
$userid = $_REQUEST['userid'];

switch ($get->ejecutar) {
    case 'profesor':
    $objx = createTapDashboardProf($get);
    break;
    
    case 'estudiante':
    $objx = createTapDashboardEstudiante($get);
        break;
    case 'permiso':
        insertarRegistrosFaltantesdelUsuario($userid);
    break;
    case 'deleteAll':
        deleteAllDataForCondition();
    break;

}
?>