<?php

chdir("../../");
require_once 'data/CRMEntity.php';
include_once 'includes/main/WebUI.php';
include_once 'vtlib/Vtiger/Module.php';
require_once 'includes/Loader.php';
require_once 'include/utils/utils.php';

vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');

ini_set('max_execution_time', 0);
set_time_limit(0);

global $current_user, $adb;
$current_user->id = 1;

#Obtiene la cantidad de casos para B2C sección 1
#$adb->setDebug(true);
$B2C_main_q = "SELECT count(p.potentialid) as n FROM vtiger_potential p JOIN vtiger_crmentity c ON c.deleted = 0 AND p.potentialid = c.crmid 
JOIN vtiger_potentialscf pc ON pc.potentialid = p.potentialid WHERE seccion = ? AND pc.cf_907 like 'B2B%'";
$r = $adb->pquery($B2C_main_q,[1]);
$count_S1_B2C = $adb->query_result($r,0,'n');
#debug($count_S1_B2C);
$B2C_seccion_i  = 2;

$loop = true;
do {
    $r = $adb->pquery($B2C_main_q,[$B2C_seccion_i]);
    $count_S_B2C = $adb->query_result($r,0,'n');
    $loop = $count_S_B2C ==  $count_S1_B2C;
    if($loop)
        $B2C_seccion_i++;
} while ($loop);

    

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Replicar Oportunidades</title>
    <link rel="SHORTCUT ICON" href="../../layouts/v7/skins/images/favicon.ico">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
</head>
<body>
    <style>
        .form_main {
            margin: 10px;
        }
        pre {
            display: block;
        }
    </style>

    <div class="row col-md-12 form_main">
        <form method="post" id="mainf">
            <div class="row col-md-12">
                <div class="form-group col-md-12">
                    <label>Generar Oportunidades para la sección: </label>
                    <input class="form-control" type="text" readonly value="<?= $B2C_seccion_i; ?>" style="background-color:#ccc;" name="n" id="n">
                </div>
                <div class="form-group col-md-12">
                    <input class="btn btn-primary" id="send" type="submit" value="Generar" name="action">
                </div>
            </div>
        </form>
    </div>
    <hr>
    <div class="row col-md-12">
        <pre class="div_result">

        </pre>
    </div>
    

    <!-- Si utilizamos componentes de Bootstrap que requieran Javascript agregar estos tres archivos -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/gasparesganga-jquery-loading-overlay@2.1.7/dist/loadingoverlay.min.js"></script>
    <script>
        $(document).ready(function(){
            $(function() {
                $('#mainf').on('submit', function (event) {
                    event.preventDefault();
                    var n = parseInt($('#n').val());
                    if(n > 0)
                    {
                        $.LoadingOverlay("show");
                        $.ajax({
                            url: "generarOportunidades.php",
                            data: "action=Generar&n="+n,
                            method: 'POST'
                        }).done(function(res) {
                            $('.div_result').html(res);
                            $('#n').val(parseInt(n)+1);
                            $.LoadingOverlay("hide");
                        });
                    }
                    else{
                        alert('Valor inválido');
                    }
                });
            });
        });
    </script>
</body>
</html>