<?php
chdir("../../");

require_once 'data/CRMEntity.php';
include_once 'includes/main/WebUI.php';
include_once 'vtlib/Vtiger/Module.php';
require_once 'includes/Loader.php';
require_once 'include/utils/utils.php';

vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');

ini_set('max_execution_time', 0);
set_time_limit(0);

global $current_user, $adb;
$current_user->id = 1;

/**
 * @method Retorna el nombre del rol que debe tener el usuario
 * @param string $tipo : b2c|b2b
 * @param integer $seccion
 * @param integer $grupo
 * 
 * @return string|null
 */
function getRole($tipo, $seccion, $grupo)
{
    global $adb;

    switch ($tipo) {
        case 'b2c': $pref = 'Ejecutivo de ventas ';                break;
        case 'b2b': $pref = 'Ejecutivo de ventas corporativas ';  break;
    }
    $tx = $pref.$seccion.".".$grupo;
    #Busca la existencia del rol en la BD 
    #$adb->setDebug(true);
    $r = $adb->pquery("SELECT roleid,rolename FROM vtiger_role WHERE rolename = '".$tx."'",[]);
    #$adb->setDebug(false);
    return $adb->num_rows($r) == 1 ? decode_html($adb->query_result($r,0,'roleid')) : "";
}

if(isset($_REQUEST['action']))
{
    switch ($_REQUEST['action']) {
        case 'Generar':
            $i = $_REQUEST['n'];
            if(!empty($i))
            {
                
                $sql_2 = "UPDATE vtiger_potential p JOIN vtiger_crmentity c ON c.deleted = 0 AND p.potentialid = c.crmid 
                JOIN vtiger_potentialscf pc ON pc.potentialid = p.potentialid SET c.deleted = 1 WHERE seccion = ? AND pc.cf_907 like ";
                #$sql_2.= " 'B2C%'";
                $sql_2.= " 'B2B%'";
                #Limpia las oportunidades de la sección $i #B2C
                $adb->pquery($sql_2,[$i]);
                
                #Obtiene los usuarios ficticios de la sección 1
                $sql = "SELECT u.* FROM vtiger_users u
                JOIN vtiger_user2role u2r ON u2r.userid=u.id 
                JOIN vtiger_role r ON r.roleid = u2r.roleid 
                WHERE u.deleted = 0 AND r.rolename like ";
                $sql.= " 'Ejecutivo de ventas corporativas 1.%' ";
                
                # $sql.= 'Ejecutivo de Ventas 1.%'";
                $q = $adb->pquery($sql,[]);

                $usuarios_1 = [];
                
                while ($row = $adb->fetch_row($q)) {
                    $usuarios_1[] = array_map("decode_html",$row);
                }

                $numbers = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10 ,11];

                #Cada iteracion representa una sección
                
                /*------------------ CREA USUARIOS DE LA SECCION 1------------------*/
                
                $users_ = []; #Matriz que mapea el usuario orignal y el generado
                $tipo_ = []; #Matriz que mapea el tipo (b2c|b2b) por usuario generado
                $grupo_ = []; #Matriz que mapea el grupo de cada usuario generado
                $seccion_ = []; #Matriz que mapea la seccion de cada usuario generado
                debug("[INFO::] GENERANDO USUARIO.......");
                foreach ($usuarios_1 as $user) {
                    $Nusername = str_replace($numbers, "", $user['user_name']).$i; #Genera el nombre de usuario de la seccion
                    #Valida que el usuario no exista
                    $query_v1 = $adb->pquery("SELECT * FROM vtiger_users WHERE user_name = ? AND deleted = 0",[$Nusername]);
                        
                    if(empty($adb->num_rows($query_v1)))
                    {
                        #Verifica si es B2C o B2B
                        $tipo = strstr($user['gerencia'],'Sucursal') === false ? 'b2b' : 'b2c';
                        #Obtiene el Grupo
                        if($tipo == "b2b") $grupo = str_replace("Corporativa ","",$user['gerencia']);
                        else if($tipo == 'b2c') $grupo = str_replace("Sucursal ","",$user['gerencia']);
                        
                        #Crea el usuario
                        $userCModel     = Users_Record_Model::getInstanceById($user['id'],'Users');
                        $NuserCModel = clone $userCModel;
                        $NuserCModel->set('mode','');
                        $NuserCModel->set('id','');
                        $NuserCModel->set('user_name',$Nusername);
                        $NuserCModel->set('roleid',getRole($tipo,$i,$grupo));
                        $NuserCModel->set('reports_to_id',''); #Se llenará luego
                        $NuserCModel->save();
                        $idUser = $NuserCModel->getId();
                        debug("[INFO]:: El usuario $Nusername has sido creado con ID $idUser.");
                    }
                    else{
                        debug("[INFO]:: El usuario $Nusername ya existe.");
                        $idUser = $adb->query_result($query_v1,0,'id');
                        $tipo = strstr($adb->query_result($query_v1,0,'gerencia'),'Sucursal') === false ? 'b2b' : 'b2c';
                        if($tipo == "b2b") $grupo = str_replace("Corporativa ","",$adb->query_result($query_v1,0,'gerencia'));
                        else if($tipo == 'b2c') $grupo = str_replace("Sucursal ","",$adb->query_result($query_v1,0,'gerencia'));
                    }

                    $users_[$user['id']] = $idUser;
                    $tipo_[$idUser] = $tipo;
                    $gerencia_[$idUser] = $user['gerencia'];
                    $grupo_[$idUser] = $grupo;
                    $gen_[$idUser] = $Nusername;
                    $seccion_[$idUser] = $i;
                    /**Configura el Informa a - de los usuarios generados: */
                }
                /*------------------ FIN ------------------*/
                
                /**
                 * ------------------ REPLICA LAS OPORTUNIDADES DE LOS USUARIOS DE LA SECCION 1------------------
                 */
                debug("[INFO::] GENERANDO OPORTUNIDADES.......");
                $c = 0;
                $s_ = 0;
                
                foreach ($users_ as $from => $to) {

                    #Verifica que el usuario $to no tenga oportunidades asignadas en su grupo.
                    #$adb->setDebug(1);
                    $qv = $adb->pquery("SELECT p.potentialid FROM vtiger_potentialscf p JOIN vtiger_crmentity c ON c.crmid = p.potentialid AND c.deleted = 0 WHERE c.smownerid = ?",[$to]);
                    #$adb->setDebug(0);
                    #debug($adb->num_rows($qv),1);
                    if(empty($adb->num_rows($qv)))
                    {
                        #Obtiene las oportunidades del usuario inicial
                        #$adb->setDebug(1);
                        $sq = $adb->pquery("SELECT p.potentialid FROM vtiger_potentialscf p JOIN vtiger_crmentity c ON c.crmid = p.potentialid AND c.deleted = 0 WHERE c.smownerid = ?",[$from]);
                        #$adb->setDebug(0);
                        $s_ += $adb->num_rows($sq);
                        if($adb->num_rows($sq) > 0)
                        {
                            debug("[INFO]:: ".$adb->num_rows($sq)." OPORTUNIDADES ENCONTRADAS PARA EL USUARIO $from");
                            while($row = $adb->fetch_row($sq))
                            {   
                                ++$c;
                                $pRecordModel = Vtiger_Record_Model::getInstanceById($row['potentialid'],'Potentials'); #Registro
                                $pNRecordModel = clone $pRecordModel; #Nueva instancia
                                $pNRecordModel->set('mode','');
                                $pNRecordModel->set('assigned_user_id',$to);
                                $pNRecordModel->set('gerencia',$gerencia_[$to]);
                                #$pNRecordModel->set('seccion',$seccion[$to]);
                                $pNRecordModel->set('id','');
                                $pNRecordModel->set('potential_no','');
                                $pNRecordModel->set('record_id','');
                                try {
                                    $pNRecordModel->save();
                                    $newId = $pNRecordModel->getId();
                                    #debug($pNRecordModel->getData());
                                    #
                                    if(!empty($newId))
                                    {
                                        $adb->pquery("UPDATE vtiger_potential SET seccion = ? WHERE potentialid = ?",[$seccion_[$to],$newId]);
                                    }
                                } catch (Exception $e) {
                                    debug("[ERROR]:: EXCEPCION ".$e->getMessage());
                                    debug($pNRecordModel->getData());
                                    debug(json_encode($e));
                                }
                                
                            }
                            
                            debug("[INFO]:: SE GENERARON LAS OPORTUNIDADES PARA EL USUARIO ".$gen_[$to]);
                        }
                        else{
                            debug("[WARNING]:: NO SE ENCONTRARON OPORTUNIDADES PARA EL USUARIO $from");
                        }
                    }
                    else{
                        debug("[ERROR]:: EL USUARIO ".$gen_[$to]." YA CUENTA CON OPORTUNIDADES ASIGNADAS.");
                    }
                }
                debug("Total: ".$s_,1);
                /*------------------ FIN ------------------*/
                
            }
            break;
        
        default:
            # code...
            break;
    }
}