<?php

chdir("../../");
require_once 'data/CRMEntity.php';
include_once 'includes/main/WebUI.php';
include_once 'vtlib/Vtiger/Module.php';
require_once 'includes/Loader.php';
require_once 'include/utils/utils.php';

vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');

ini_set('max_execution_time', 0);
set_time_limit(0);

global $current_user;
$current_user->id = 1;

/**
 * Script cambia el nombre de usuario de todos los usuarios Ejecutivos
 */
function main()
{
    global $adb;
    debug("[INFO]:: Buscando usuarios con rol 'Ejecutivo de Ventas corporativas.'");
    $r = $adb->pquery("SELECT u.id FROM vtiger_users u
                        JOIN vtiger_user2role u2r ON u2r.userid=u.id 
                        JOIN vtiger_role r ON r.roleid = u2r.roleid 
                        WHERE u.deleted = 0 AND r.rolename like '%Ejecutivo de Ventas corporativas%'",[]);

    debug("[INFO]:: ".$adb->num_rows($r)." registros encontrados.");
    if($adb->num_rows($r) > 0)
    {
        while($row = $adb->fetch_row($r))
        {
            $id         = $row['id'];
            $userModel  = Users_Record_Model::getInstanceById($id,'Users');
            $username   = $userModel->get('user_name');
            $lastchar = $username[strlen($username)-1]; #Obtiene el ultimo caracter para validar si ya tiene un correlativo.
            if(!is_numeric($lastchar))
            {
                $n_username = $username."1";
                $userModel->set('mode','edit');
                $userModel->set('user_name',$n_username);
                $userModel->save();
                debug("[SUCCESS]:: El usuario ".$username." ha sido cambiado a ".$n_username);
            }
            else{
                debug("[ERROR]:: El usuario ".$username." ya cuenta con un correlativo.");
            }
        }
    }
   
}

main();