/**
 * @copyright Creantis
 * @author Cgarcia
 * @date  2024-01-30
 * @description 
 * 
 * @Libreria
 * layouts/v7/resources/lib/echarts/*
 * 
 * @Archivos
 * layouts/v7/modules/Vtiger/resources/dashboards/Widget.js
 * layouts/v7/modules/Vtiger/resources/DashBoard.js
 * layouts/v7/modules/Vtiger/dashboards/DashBoardWidgetContents.tpl
 * layouts/v7/modules/Vtiger/Header.tpl
 */
var optionTest = {
    "title": {
        "text": "Caso B2B-01: Cartera total por vendedor",
        "textStyle": {
            "fontSize": 12
        }
    },
    "color": [
        "#ffc431",
        "#f59c00",
        "#FFA424",
        "#FFCC84",
        "#474747",
        "#ffb600",
        "#ffb959"
    ],
    "tooltip": {
        "trigger": "axis",
        "axisPointer": {
            "type": "shadow"
        }
    },
    "toolbox": {
        "feature": {
            "dataView": {
                "readOnly": false
            },
            "restore": {},
            "saveAsImage": {}
        }
    },
    "grid": {
        "top": 50,
        "left": 150,
        "bottom": 60
    },
    "xAxis": {
        "type": "value",
        "position": "top",
        "splitLine": {
            "lineStyle": {
                "type": "dashed"
            }
        }
    },
    "yAxis": {
        "type": "category",
        "data": [
            "Alejandra Cruz",
            "Alex Nano",
            "Aurelio Casillas",
            "Cristhian Ascoy",
            "Jimmy Guevara",
            "Muriel Calderon",
            "Selena Quiroz"
        ],
        "axisLabel": {
            "interval": 0,
            "rotate": 30
        }
    },
    "series": [
        {
            "name": "Cant.",
            "type": "bar",
            "label": {
                "show": true
            },
            "data": [
                1,
                259,
                261,
                239,
                259,
                258,
                260
            ]
        }
    ]
}

var vtEchart={
	Funel:'',
	Pie:'',
	MultiBar:'',
	Bar:'',
	SingleChat:'',
}
var CreantisColors = [
    /*'#f59c00',
    '#a6c9e2',
    '#b6e5b0',
    '#f5b7b1',
    '#f8e5a2',
    '#dcb4e5',
    '#c0c0c0',
    '#f5bdd3',
    '#d2b48c',
    '#a2ded0'*/
/*
    '#3498db',
    '#2ecc71',
    '#e67e22',
    '#f1c40f',
    '#95a5a6',
    '#16a085',
    '#e91e63',
    '#d35400',
*/
/*
"#ffd564",
"#fe9d97",
"#fffec8",
"#d8fd94",
"#bded7e",
"#ffe7bf",
"#bdcdd0",
*/

"#ffff00",
"#eae2cf",
"#b4ccb9",
"#f6aa3d",
"#7dad93",
"#bacca4",
"#f7eeaa",
"#edb552",
/*
    '#3498db',
    '#f59c00',  // Naranja más claro
    '#2ecc71',
    '#f7ca18',  // Amarillo más claro
    '#bdc3c7',  // Gris más claro
    '#ffcc84'   // Naranja original
*/


/*
	'#EC8800',
  '#FFA424',
  '#FFCC84',
  '#474747',
  '#ffc431',
  '#ffb600',
  '#ffb959',*/
];


var CreantisColor2 = [
  '#ffc431',
  '#f59c00',
  '#FFA424',
  '#FFCC84',
  '#474747',
  '#ffb600',
  '#ffb959',
];



/**
 * https://echarts.apache.org/examples/en/editor.html?c=funnel
 * @returns options
 */
function funelEchartjs(){
	return {
		title: {
		  text: ''
		},
		color:CreantisColors,
		tooltip: {
		  trigger: 'item',
		  formatter: ''
		},
		toolbox: {
		  feature: {
			dataView: { readOnly: false },
			restore: {},
			saveAsImage: {}
		  }
		},
		legend: {
			orient: 'vertical',
			left: 'left',
		  data: []
		},
		series: [
		  {
			name: '',
			type: 'funnel',
			left: '0%',
			top: 20,
			bottom: 10,
			width: '100%',
			min: 0,
			max: 100,
			minSize: '0%',
			maxSize: '100%',
			sort: 'descending',
			gap: 2,
			/*label: {
			  show: true,
			  position: 'inside',
			  color: '#fff'
			},*/
			labelLine: {
			  length: 10,
			  lineStyle: {
				width: 1,
				type: 'solid'
			  }
			},
			itemStyle: {
			  borderColor: '#fff',
			  borderWidth: 1
			},
			emphasis: {
			  label: {
				fontSize: 14
			  }
			},
			data: []
		  }
		]
	  };
}

/**
 * https://echarts.apache.org/examples/en/editor.html?c=bar-label-rotation
 * @returns options
 */
function barLabelRotationEchartjs(){
	var app = {};
	const posList = [
		'left','right','top','bottom','inside','insideTop'
		,'insideLeft','insideRight','insideBottom','insideTopLeft'
		,'insideTopRight','insideBottomLeft','insideBottomRight'
	];

	app.configParameters = {
			rotate: {
			min: -90,
			max: 90
		},
		align: {
			options: {
			left: 'left',
			center: 'center',
			right: 'right'
			}
		},
		verticalAlign: {
			options: {
			top: 'top',
			middle: 'middle',
			bottom: 'bottom'
			}
		},
		position: {
			options: posList.reduce(function (map, pos) {
			map[pos] = pos;
			return map;
			}, {})
		},
		distance: {
			min: 0,
			max: 100
		}
		};

	app.config = {
		rotate: 90,
		align: 'left',
		verticalAlign: 'middle',
		position: 'insideBottom',
		distance: 15,
		onChange: function () {
			const labelOption = {
			rotate: app.config.rotate,
			align: app.config.align,
			verticalAlign: app.config.verticalAlign,
			position: app.config.position,
			distance: app.config.distance
			};
			myChart.setOption({
			series: [
				{
				label: labelOption
				},
				{
				label: labelOption
				},
				{
				label: labelOption
				},
				{
				label: labelOption
				},
				{
				label: labelOption
				},
				{
				label: labelOption
				},
				{
				label: labelOption
				}
			]
			});
		}
	};

	const labelOption = {
		show: true,
		position: app.config.position,
		distance: app.config.distance,
		align: app.config.align,
		verticalAlign: app.config.verticalAlign,
		rotate: app.config.rotate,
		formatter: '{c}  {name|{a}}',
		fontSize: 12,
		rich: {
			name: {}
		}
	};

	return {
		config:
		{
			labelOption:labelOption
		},
		color:CreantisColors,
		tooltip: {
		  trigger: 'axis', 
		  axisPointer: {
			type: 'shadow'
		  }
		},
		legend: {
		  data: [],//['Forest', 'Steppe', 'Desert', 'Wetland']
		},
		toolbox: {
		  show: true,
		  orient: 'vertical',
		  left: 'right',
		  top: 'center',
		  feature: {
			mark: { show: true },
			dataView: { show: true, readOnly: false },
			magicType: { show: true, type: ['line', 'bar', 'stack'] },
			restore: { show: true },
			saveAsImage: { show: true }
		  }
		},
		xAxis: [
		  {
			type: 'category',
			axisTick: { show: false },
			data: ['2012', '2013', '2014', '2015', '2016']
		  }
		],
		yAxis: [
		  {
			type: 'value'
		  }
		],
		series: [
		  {
			name: 'Forest',
			type: 'bar',
			barGap: 0,
			label: labelOption,
			emphasis: {
			  focus: 'series'
			},
			data: [320, 332, 301, 334, 390]
		  },
		  {
			name: 'Steppe',
			type: 'bar',
			label: labelOption,
			emphasis: {
			  focus: 'series'
			},
			data: [220, 182, 191, 234, 290]
		  },
		  {
			name: 'Desert',
			type: 'bar',
			label: labelOption,
			emphasis: {
			  focus: 'series'
			},
			data: [150, 232, 201, 154, 190]
		  },
		  {
			name: 'Wetland',
			type: 'bar',
			label: labelOption,
			emphasis: {
			  focus: 'series'
			},
			data: [98, 77, 101, 99, 40]
		  }
		]
	  };

}

/**
 * https://echarts.apache.org/examples/en/editor.html?c=bar-negative2
 * @returns options
 */
function simpleBarEchartjs(){
	return {
	title: {
	  text: '',
	  textStyle:{
		fontSize:12,
	  }
	},
	color:CreantisColor2,
	tooltip: {
	trigger: 'axis',
	axisPointer: {
			type: 'shadow'
		}
	},
	toolbox: {
		top:20,
		orient:'vertical',
		feature: {
		  dataView: { readOnly: false },
		  saveAsImage: {
			show: true,
            title: 'Guardar'
		  },
		}
	  },
	grid: {
	  top: 50,
	  left: 180,
	  bottom: 0
	},
	xAxis: {
		minInterval: 5,
		type: 'value',
	  position: 'top',
	  splitLine: {
		lineStyle: {
		  type: 'dashed'
		}
	  },
	},
	yAxis: {
	  type: 'category',
	  data: [],//[ 'ten', 'nine', 'eight', 'seven', 'six', 'five', 'four', 'three', 'two', 'one'  ]
	  axisLabel: { interval: 0, rotate: 0 }

	},
	series: [
	  {
		name: 'Cant.',
		type: 'bar',
		label: {
		  show: true,
		},
		data: []//[ 17, 59, 200, 44, 23, 18, 17, 47, 36, 18 ]
	  }
	]
  };
}


/**
 * https://echarts.apache.org/examples/en/editor.html?c=bar-simple
 * @returns 
 */
function simpleBarEchartjs2(){
	return {
	color:CreantisColor2,
	title: {
		text: '',
		textStyle:{
		  fontSize:12,
		}
	  },
	xAxis: {
	  type: 'category',
	  data:[]// ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
	},
	tooltip: {
	  trigger: 'axis',
	  axisPointer: {
			  type: 'shadow'
		  }
	  },
	  toolbox: {
		  top:20,
		  orient:'vertical',
		  feature: {
			dataView: { readOnly: false },
			saveAsImage: {
			  show: true,
			  title: 'Guardar'
			},
		  }
		},
	grid: {
	  left: '3%',
	  right: '4%',
	  bottom: '3%',
	  containLabel: true
	},
	yAxis: {
	  type: 'value'
	},
	series: [
	  {
		label: {
			show: true,
			},
		data:[],// [120, 200, 150, 80, 70, 110, 130],
		type: 'bar'
	  }
	]
  };
}



/**
 * https://echarts.apache.org/examples/en/editor.html?c=pie-simple
 * @returns 
 */
function pieEchartjs(){
	return {
		color:CreantisColors,
		title: {
			text: '',
			subtext: '',
			left: 'center'
		},
		tooltip: {
			trigger: 'item'
		},
		toolbox: {
			show: true,
			feature: {
			  mark: { show: true },
			  dataView: { show: true, readOnly: false },
			  restore: { show: true },
			  saveAsImage: { show: true }
			}
		  },
		legend: {
			orient: 'vertical',
			type: 'scroll',
			left: 'left',
			top: 20,
			bottom: 20,
			data:[],
		},
		label: {
				//formatter: '{a|{a}}{abg|}\n{hr|}\n  {b|{b}：}{c}  {per|{d}%}  ',
				//formatter: (req)=>{ console.log('----------------',req) },//'{b|{b}：} {c}  {per|{d}%}  ',
				formatter: '{b|{b}：} {c}  {per|{d}%}  ',
				//backgroundColor: '#F6F8FC',
				//borderColor: '#8C8D8E',
				borderWidth: 1,
				borderRadius: 4,
				rich: {
				a: {
					color: '#6E7079',
					lineHeight: 22,
					align: 'center'
				},
				hr: {
					borderColor: '#8C8D8E',
					width: '100%',
					borderWidth: 1,
					height: 0
				},
				b: {
					color: '#4C5058',
					fontSize: 12,
					fontWeight: 'bold',
					lineHeight: 33
				},
				per: {
					color: '#fff',
					backgroundColor: '#4C5058',
					padding: [3, 4],
					borderRadius: 4
				}
				}
			},
		series: [
			{
			//name: 'Data',
			type: 'pie',
			radius: '40%',
			data:[], /*[
				{ value: 1048, name: 'Search Engine' },
				{ value: 735, name: 'Direct' },
				{ value: 580, name: 'Email' },
				{ value: 484, name: 'Union Ads' },
				{ value: 300, name: 'Video Ads' }
			],*/
			emphasis: {
				itemStyle: {
				shadowBlur: 10,
				shadowOffsetX: 0,
				shadowColor: 'rgba(0, 0, 0, 0.5)'
				}
			}
			}
		]
	};
}


/**
 * https://echarts.apache.org/examples/en/editor.html?c=bar-label-rotation
 * @returns options
 */
function barEchartjs(){

	return {
		color:CreantisColor2,
		xAxis: {
		  type: 'category',
		  splitLine: { show: false },
		  data: []//['Total', 'Rent', 'Utilities', 'Transportation', 'Meals', 'Other']
		},
		yAxis: {
		  type: 'value'
		},
		series: [
		  {
			type: 'bar',
			stack: 'Total',
			label: {
			  show: true,
			  position: 'inside'
			},
			data: []//[2900, 1200, 300, 200, 900, 300]
		  }
		]
	  };

}


/**
 * https://echarts.apache.org/examples/en/editor.html?c=bar-waterfall
 * @returns options
 */
function EchartSimpleBar_(obj){
	CLog.warning('EchartSimpleBar_::obj', obj);
	let fngetDom= getDom(obj)

	let option ={}//simpleBarEchartjs();

	if(obj.type === "verticalbarChart"){
		option =simpleBarEchartjs2()
		option.xAxis.data = obj.labels
	}else{
		option =simpleBarEchartjs()
		option.yAxis.data = obj.labels
		option.xAxis.minInterval = Math.min(...obj.data.flat())/2;
	};



	vtEchart.SingleChat = echarts.init(fngetDom.dom, null, {
		renderer: 'canvas',
		useDirtyRect: false
	  });
	  option.title.text = obj.title
	  option.series[0].data = obj.data.flat();

	  //option.yAxis.data = obj.labels
	  //option.xAxis.minInterval = Math.min(...obj.data.flat())/2;


	  //borrar cuadro de la vieja grafica
	  if(fngetDom.chartdetail){
		donContent.querySelector(`.dashboardWidgetContent`).innerHTML=''
		option.title.text = ''
	  }

		
	  vtEchart.SingleChat.setOption(option);
	  vtEchart.SingleChat.resize();

	onClickGraf(vtEchart.SingleChat, obj)

		
		CLog.warning('EchartSimpleBar_::option',option)


}


/**
 * https://echarts.apache.org/examples/en/editor.html?c=bar-waterfall
 * @returns options
 */
function EchartBarWidget(obj){
	CLog.info('EchartBarWidget::obj', obj);
	donContent= (obj.id)? document.querySelector(`[id="${obj.id}"]`) : document;
	let dom= donContent.querySelector(`[data-name="${obj.grafica}"] .widgetChartContainer`)
	
	let option =barEchartjs();
	vtEchart.Bar = echarts.init(dom, null, {
		renderer: 'canvas',
		useDirtyRect: false
	  });

	  option.series[0].data = obj.chartData[0]
	  option.xAxis.data = obj.labels

		option && vtEchart.Bar.setOption(option);
		vtEchart.Bar.resize();
		
}



//PIE
function EchartTotalRevenuePerSalesPerson(dataParse){
	CLog.fn('EchartTotalRevenuePerSalesPerson',dataParse);
	let fngetDom= getDom(dataParse)

	let option =pieEchartjs();
	vtEchart.Pie = echarts.init(fngetDom.dom, null, {
		renderer: 'canvas',
		useDirtyRect: false
	  });

	  option.series[0].data = dataParse.chartData.map(function(item) {
		return {
		  value: parseFloat(item["1"]),
		  name: item["0"]
		};
	  });
	  option.legend.data =
	console.log(option , 'option');
	option && vtEchart.Pie.setOption(option);
	vtEchart.Pie.resize();


	  //borrar cuadro de la vieja grafica
	  if(fngetDom.chartdetail){
		donContent.querySelector(`.dashboardWidgetContent`).innerHTML=''
		option.title.text = ''
	  }

	onClickGraf(vtEchart.Pie, dataParse)

}



function EchartGroupedBySalesStage(dataParse){
	CLog.info('GroupedBySalesStage::dataParse', dataParse);

	let contenedor= document.querySelector(`[data-name="${dataParse.grafica}"] .widgetChartContainer`)
	let optionfunel =funelEchartjs();
	vtEchart.Funel = echarts.init(contenedor, null, {
		renderer: 'canvas',
		useDirtyRect: false
	  });

	  optionfunel.series[0].data = dataParse.map(function(item) {
		return {
		  value: parseFloat(item["1"]),
		  name: item["0"]
		};
	  });

	  optionfunel.legend.data = dataParse.map( item => item["0"] )

		optionfunel && vtEchart.Funel.setOption(optionfunel);
		vtEchart.Funel.resize();
}



function EchartMultibar(dataParse){
	CLog.info('EchartMultibar::dataParse', dataParse);
	
	donContent= (dataParse.id)? document.querySelector(`[id="${dataParse.id}"]`) : document;
	
	let dom = donContent.querySelector(`[data-name="${dataParse.grafica}"] .widgetChartContainer`)
	vtEchart.MultiBar = echarts.init(dom, null, {
		renderer: 'canvas',
		useDirtyRect: false
	  });
	
	//contruir las obsiones con la data
	let optionbar = barLabelRotationEchartjs();
	var series = dataParse.labels.map(function(label, index) {
		return {
			name: label,
			type: 'bar',
			label: optionbar.config.labelOption,
			emphasis: {
				focus: 'series'
			},
			data: dataParse.data[index]
		};
	});


	optionbar.legend.data = dataParse.labels
	optionbar.series= series
	optionbar.xAxis[0].data = dataParse.ticks

		//console.log('EchartMultibar::series',series,optionbar)

		optionbar && vtEchart.MultiBar.setOption(optionbar);
		vtEchart.MultiBar.resize();

		vtEchart.MultiBar.on('click', function(params) {
			//console.log(params ,dataParse.links[params.componentIndex])
			window.open( dataParse.links[params.componentIndex] );
		  });

}


function EchartParseDataSingleBar(fuente, container){
	CLog.log('EchartSingleBar::fuente', fuente );
	CLog.log('EchartSingleBar::container', container );
	return {
		fuente: fuente,
		data: fuente.values,
		ticks: fuente.data_labels,
		labels: fuente.labels,
		links: fuente.links,
		grafica: container.name,
		id: container.id,
		title:fuente.graph_label,
		type:container.charttype,
	}
}



function onClickGraf(selector, dataParse) {
	selector.on('click', function(params) {
		console.log('onClickGraf::componentIndex',params.name, dataParse.links)
		const nameMappings = {
			"Perdida": "Closed+Lost",
			"Cierre": "Closed+Won",
			"Visita": "Analisis+de+Necesidad",
			"Cotizaciones": "Cotizacion",
			"Propuesta": "Negociacion",
			"Oportunidad": "Separacion",
		};
		params.name = params.name.replace(/ /g, '+');
		params.name = (nameMappings[params.name])
		? params.name = nameMappings[params.name]
		: params.name;
		
		
		window.open( dataParse.links.find(link => link.includes(params.name)) );
	  });
}


function getDom(obj) {
	donContent= (obj.id)? document.querySelector(`[id="${obj.id}"]`) : document;
	let contDash = donContent.querySelector(`[data-name="${obj.grafica}"] .widgetChartContainer`)
	let contFullChart = document.querySelector(`#reports-chartdetail`)
	// determinar si el dom es witget o modal
	dom= document.querySelector('.myModal[style="display: block;"] .modal-body')?? false;
	dom= (!dom && contDash)
		? contDash
		:contFullChart; // para los reportes ChartDetail 
	
	CLog.warning('getDom::dom', dom);
	return {
		dom,
		chartdetail: contFullChart
	};
}


// layouts/v7/modules/Vtiger/resources/DashBoard.js
function resideECharts() {
	let elemALL = document.querySelectorAll('[_echarts_instance_]');

    elemALL.forEach(elem => {
        let a = echarts.init(elem)
        a.resize()
    });
}


/******** END Creantis****** */