console.log('init validaciones class')


    const onlyNumbers = (event) => { event.target.value = event.target.value.replace(/[^0-9]/g, ''); }
    const onlyTxt = (event) => { event.target.value = event.target.value.replace(/[^A-Za-záéíóúüÜÁÉÍÓÚ\s,.;]/g, ''); }
    const onlyTxtNumber = (event) => { event.target.value = event.target.value.replace(/[^A-Za-z0-9áéíóúüÜÁÉÍÓÚ\s,.;]/g, ''); }
    const onlyNumbersComa = (event) => { event.target.value = event.target.value.replace(/[^0-9,]/g, ''); }
    const onlyNumbersPunto = (event) => { event.target.value = event.target.value.replace(/[^0-9.]/g, ''); }
    const onlyDecimal = (event) => { event.target.value = event.target.value.replace(/[^0-9.,]/g, ''); }
    const onlyWebsite = (event) => { event.target.value = event.target.value.replace(/[^a-zA-Z0-9\-._~:/?#[\]@!$&'()*+,;=]/g, ''); }

      
    document.querySelectorAll('.numero').forEach(function(elemento) {
        elemento.addEventListener('input', onlyNumbers);
      });
      
      document.querySelectorAll('.texto').forEach(function(elemento) {
        elemento.addEventListener('input', onlyTxt);
      });

      document.querySelectorAll('.textodecimal').forEach(function(elemento) {
        elemento.addEventListener('input', onlyTxtNumber);
      });

      document.querySelectorAll('.decimalcoma').forEach(function(elemento) {
        elemento.addEventListener('input', onlyNumbersComa);
      });

      document.querySelectorAll('.textoentero').forEach(function(elemento) {
        elemento.addEventListener('input', onlyNumbersPunto);
      });

      document.querySelectorAll('.decimal').forEach(function(elemento) {
        elemento.addEventListener('input', onlyDecimal);
      });

      document.querySelectorAll('.website').forEach(function(elemento) {
        elemento.addEventListener('input', onlyWebsite);
      });

      document.querySelectorAll('.rucperu').forEach(elemento => {
        const campoRUC = elemento.parentElement; // Obtén el elemento padre del campo de entrada
      
        // Crea el elemento de mensaje de validación
        const mensajeValidacion = document.createElement('div');
        mensajeValidacion.classList.add('mensaje-validacion');
        campoRUC.appendChild(mensajeValidacion);
        mensajeValidacion.style.position = 'absolute'; 
      
        elemento.addEventListener('input', event => {
          const ruc = event.target.value;
          onlyNumbers(event);
      
          if (ruc.length <= 11) {
            const esValido = rucValido(ruc);
            mensajeValidacion.textContent = esValido ? '' : 'RUC no válido';
            mensajeValidacion.style.display = 'block'; 
            campoRUC.style.borderColor = esValido ? '#ccc' : '#B94A48';
            event.target.style.backgroundColor = esValido ? 'transparent' : '#ffeeee';
          } else {
            mensajeValidacion.textContent = 'RUC no válido, mayor a 11 dígitos';
            mensajeValidacion.style.display = 'block'; 
            campoRUC.style.borderColor = '#B94A48';
            event.target.style.backgroundColor = '#ffeeee';
          }
        });

        elemento.addEventListener('focusout', event => {
          const ruc = event.target.value;
          const esValido = rucValido(ruc);
      
          if (!esValido) {
            event.target.value = ''; // Borra el contenido del campo si el RUC no es válido al salir del campo
          }
        });


      });
      
      
      
      
