<?php
chdir("../../../../");

require_once 'includes/Loader.php';
require_once 'include/utils/utils.php';
require_once 'libraries/Smarty/libs/Smarty.class.php';
vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');



function main($param)
{
    global $adb, $current_user,$document_root;
    $current_user = Users::getActiveAdminUser();

    switch ($param['action']) {
        case 'get_rel_fields':
            $moduleName = $param['module'];
            #Obtiene los campos relacionados
            $a = $adb->pquery("SELECT tabid FROM vtiger_tab WHERE name=? AND presence IN (0,2)",[$moduleName]);
            if($adb->num_rows($a) > 0)
            {
                $tabid = $adb->query_result($a,0,'tabid');
                $rq = $adb->pquery("SELECT tabid,fieldlabel,fieldid, fieldname FROM vtiger_field WHERE uitype IN(10) AND presence IN(0,2) AND tabid = ?",[$tabid]);
                if($adb->num_rows($rq) > 0)
                {
                    for ($i=0; $i < $adb->num_rows($rq); $i++) { 
                        $fieldid = $adb->query_result($rq,$i,'fieldid');
                        $result[$fieldid]['label'] = vtranslate(decode_html($adb->query_result($rq,$i,'fieldlabel')),$moduleName);
                        $result[$fieldid]['fieldname'] = $adb->query_result($rq,$i,'fieldname');
                        
                        #Obtiene los módulos relaciones a los que tiene acceso
                        $as = $adb->pquery("SELECT relmodule FROM vtiger_fieldmodulerel WHERE fieldid = ? LIMIT 1",[$fieldid]);
                        if(!empty($adb->num_rows($as)))
                        {
                            $result[$fieldid]['relmodule'] = vtranslate(decode_html($adb->query_result($as,0,'relmodule')),$moduleName);
                            $modulerel = decode_html($adb->query_result($as,0,'relmodule'));
                            $result[$fieldid]['relmodule_'] = $modulerel;
                            
                            //Obtenemos el tab id de los modulos relacionados }
                            
                            $q_tab = $adb->pquery("SELECT tabid FROM vtiger_tab WHERE name = ? LIMIT 1",[$modulerel]);
                            $result[$fieldid]['tabid'] = decode_html($adb->query_result($q_tab,0,'tabid'));
                            
                        }
                    }
                }
            }
            break;
        
        case 'get_fields':

            //Parameters
            $tabid = $param['tabid'];

            #Obtenemos todos los campos 
            $q_fields = $adb->pquery("SELECT fieldid,fieldname,fieldlabel FROM vtiger_field WHERE tabid = ?",[$tabid]);
            if($adb->num_rows($q_fields) > 0){

                //Recorremos los registros
                for ($i=0; $i < $adb->num_rows($q_fields); $i++) { 

                    $fieldid = $adb->query_result($q_fields,$i,'fieldid');
                    $result[$fieldid]['fieldname'] = $adb->query_result($q_fields,$i,'fieldname');
                    $result[$fieldid]['fieldlabel'] = $adb->query_result($q_fields,$i,'fieldlabel');
                }
            }
            

            break;
        case 'get_settings':

            #Obtenemos todos los campos 
            $q = $adb->pquery("SELECT *FROM complemento_fields_autocomplete",[]);
            if($adb->num_rows($q) > 0){

                //Recorremos los registros
                for ($i=0; $i < $adb->num_rows($q); $i++) { 

                    $module = $adb->query_result($q,$i,'module');
                    $modulerel = $adb->query_result($q,$i,'modulerel');
                    $fieldrel = $adb->query_result($q,$i,'fieldrel');
                    $module_field = $adb->query_result($q,$i,'module_field');
                    $modulerel_field = $adb->query_result($q,$i,'modulerel_field');

                    //Get Labels
                    $labels = $adb->pquery("SELECT fieldlabel FROM vtiger_field WHERE fieldname IN(?,?) AND tabid = (SELECT tabid FROM vtiger_tab WHERE name = ? LIMIT 1)",[$fieldrel,$module_field,$module]);

                    $cfaid = $adb->query_result($q,$i,'cfaid');
                    $result[$cfaid]['fieldrel'] = $fieldrel;
                    $result[$cfaid]['fieldrel_label'] = $adb->query_result($labels,0,'fieldlabel');
                    
                    $result[$cfaid]['module'] = $module;
                    $result[$cfaid]['module_field'] = $module_field;
                    $result[$cfaid]['module_field_label'] = $adb->query_result($labels,1,'fieldlabel');
                    
                    
                    
                    $result[$cfaid]['modulerel'] = $modulerel;
                    $result[$cfaid]['modulerel_field'] = $modulerel_field;
                    $labels = $adb->pquery("SELECT fieldlabel FROM vtiger_field WHERE fieldname = ? AND tabid = (SELECT tabid FROM vtiger_tab WHERE name = ? LIMIT 1)",[$modulerel_field,$modulerel]);
                    $result[$cfaid]['modulerel_field_label'] = $adb->query_result($labels,0,'fieldlabel') ;
                    
                }
            }
            
        break;


        case 'save_settings':
            $module = $param['module'];
            $fieldrel = $param['fieldrel'];
            $modulerel_field = $param['modulerel_field'];
            $modulerel = $param['modulerel'];
            $module_field = $param['module_field'];

            $adb->pquery("INSERT INTO complemento_fields_autocomplete VALUES(null,?,?,?,?,?)",[$module,$fieldrel,$modulerel_field,$modulerel,$module_field]);
        break;
            
        case 'delete_settings':
            $cfaid = $param['cfaid'];
            $adb->pquery("DELETE FROM complemento_fields_autocomplete WHERE cfaid = ?",[$cfaid]);
        break;
        
        
            
    }
    

    echo json_encode($result);
}

main($_REQUEST);
?>